/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.sample;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.SampleException;
import org.jtp.common.util.DateUtils;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.test.TestTable;
import org.jtp.entity.test.TestTableDetail;
import org.jtp.logic.test.TestTableService;
import org.jtp.web.WebConstants;
import org.jtp.web.action.BaseDownloadAction;
import org.jtp.web.bean.PdfBean;
import org.jtp.web.report.CsvReportGenerator;
import org.jtp.web.report.PdfReportGenerator;
import org.jtp.web.report.ReportGenerator;

/**
 * 検索画面アクションクラスです。
 * 
 * @struts.action
 *  name="sample/InputForm"
 *  path="/sample/search"
 *  scope="request"
 *  validate="true"
 *  input="/sample/search.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="search"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="save"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="update"
 *  path="/sample/update.tiles"
 * @struts.action-forward
 *  name="remove"
 *  path="/sample/remove.tiles"
 * @struts.action-forward
 *  name="download"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="pdf"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/jsp/common/menu.jsp"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SearchAction extends BaseDownloadAction {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(SearchAction.class);

    /** テストテーブル情報サービス */
    private TestTableService testTableService;

    
    /**
     * テストテーブル情報サービスを設定します。
     * @param testTableService テストテーブル情報サービス
     */
	public void setTestTableService(TestTableService testTableService) {
		this.testTableService = testTableService;
	}
    
    /**
     * 検索アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward search(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		TestTable condition = new TestTable();
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), condition);
		
		List result = testTableService.find(condition);
		
		getSession(request).setAttribute("list", result);
		request.setAttribute("testTable", condition);

    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }

	/**
	 * 登録アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward save(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		TestTable condition = new TestTable();
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), condition);
		
		_log.info("save");
		
		testTableService.save(condition);
		
		getSession(request).setAttribute("list", testTableService.find(new TestTable()));

    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 更新アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward update(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("list");
    	TestTable testTable = (TestTable) list.get(index);
     	request.setAttribute("testTable", testTable);
     	Set detail = testTable.getTestTableDetails();
     	for (Iterator it = detail.iterator(); it.hasNext();) {
        	request.setAttribute("testTableDetail", it.next());
     	}
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 削除アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward remove(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("list");
    	request.setAttribute("testTable", list.get(index));
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 戻るアクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@Override
	public ActionForward cancelled(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
    	getSession(request).removeAttribute("list");
    	return super.cancelled(mapping, form, request, response);
    }
	
    /**
     * PDFファイルをダウンロードします。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward pdf(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
    	return super.download(mapping, form, request, response);
	}

	/**
	 * 改頁アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@Override
	public ActionForward page(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		TestTable condition = (TestTable) request.getSession().getAttribute("testTable");
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), condition);
		return super.page(mapping, form, request, response);
	}

    /**
     * クライアントに送り返されるレスポンスのコンテントタイプを取得します。
     * @param form 存在するならば、このリクエストのためのActionForm Bean
     * @param request 処理しているHTTPリクエスト
     * @return クライアントに送り返されるレスポンスのコンテントタイプ
     */
	@Override
    protected String getContentType(ActionForm form, HttpServletRequest request) {
		String result = super.getContentType(form, request);
		String event = request.getParameter(FORWARD_EVENT);
		if ("pdf".equals(event)) {
			result = WebConstants.CONTENT_TYPE_PDF;
		}
		return result;
    }
    
    /**
     * ダウンロードファイル名を取得します。
     * @param form 存在するならば、このリクエストのためのActionForm Bean
     * @param request 処理しているHTTPリクエスト
     * @return ダウンロードファイル名
     */
	@Override
    protected String getFileName(ActionForm form, HttpServletRequest request) {
		String result = null;
		String event = request.getParameter(FORWARD_EVENT);
    	String date = DateUtils.dateToString(new Date(), "yyyyMMddHHmmss");
		if ("download".equals(event)) {
			result = "ほげ-" + date + ".txt";
		}
		else if ("pdf".equals(event)) {
			result = "ほげ-" + date + ".pdf";
		}
		return result;
	}

    /**
     * ダウンロードファイルの入力ストリームを取得します。
     * @param form 存在するならば、このリクエストのためのActionForm Bean
     * @param request 処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return ダウンロードファイルの入力ストリーム
     * @throws IOException I/O例外
     */
	@Override
	@SuppressWarnings("unchecked")
    protected InputStream getDownloadStream(ActionForm form,
    		HttpServletRequest request,	HttpServletResponse response) throws IOException {

    	ReportGenerator genetator;
    	List list = null;
    	
    	if (response.getContentType().equals(WebConstants.CONTENT_TYPE_PDF)) {
    		genetator = new PdfReportGenerator();
    		List arg = (List) getSession(request).getAttribute("list");
    		list = new ArrayList();
    		for (Iterator it = arg.iterator(); it.hasNext();) {
    			TestTable entity = (TestTable) it.next();
    			PdfBean pdf = new PdfBean();
    			PropertyUtilsWrapper.copyProperties(entity, pdf);
   		     	Set set = entity.getTestTableDetails();
   		     	for (Iterator ite = set.iterator(); ite.hasNext();) {
   		     		TestTableDetail detail = (TestTableDetail) ite.next();
   		    		PropertyUtilsWrapper.copyProperties(detail, pdf);
   		     	}
   		     	list.add(pdf);
    		}
    	}
    	else {
    		genetator = new CsvReportGenerator();
    		list = (List) getSession(request).getAttribute("list");
    	}
    	
		return genetator.generate(getServletContext(), list);
	}
	
	/**
	 * トークン保存を行なわないかを確認します
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	@Override
	protected boolean isSkipSaveToken(HttpServletRequest request) {
		String event = request.getParameter(FORWARD_EVENT);
		return ("download".equals(event) || "pdf".equals(event));
	}
}
