/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.mail.MailAddressTableDao;
import org.jtp.entity.mail.MailAddressTable;


/** 
 * メールアドレステーブル情報のサービスクラスです。
 * 
 * @spring.bean id="mailAddressTableService" 
 * @spring.property name="mailAddressTableDao" ref="mailAddressTableDao"
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class MailAddressTableServiceImpl implements MailAddressTableService {

	/** メールアドレステーブル情報DAO */
	private MailAddressTableDao mailAddressTableDao;
	
    /**
     * Setter Injection
     */
	public void setMailAddressTableDao(MailAddressTableDao mailAddressTableDao) {
		this.mailAddressTableDao = mailAddressTableDao;
	}
	
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List findAll() throws SampleException {
    	return mailAddressTableDao.findAll();
    }
    
	/**
	 * 登録します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailAddressTable mailAddressTable) throws SampleException {
    	mailAddressTableDao.save(mailAddressTable);
    }

	/**
	 * 更新します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(MailAddressTable mailAddressTable) throws SampleException {
    	mailAddressTableDao.update(mailAddressTable);
    }
    
	/**
	 * 削除します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(MailAddressTable mailAddressTable) throws SampleException {
    	mailAddressTableDao.delete(mailAddressTable);
    }
}
