/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.mail.MailAccountTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="mailAccountTableDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class MailAccountTableDaoImpl extends BaseDao implements MailAccountTableDao {
	
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List findAll() throws SampleException {
    	return getHibernateTemplate().loadAll(MailAccountTable.class);
    }
    
	/**
	 * 登録します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailAccountTable mailAccountTable) throws SampleException {
    	getHibernateTemplate().save(mailAccountTable);
    	getHibernateTemplate().flush();
    }

	/**
	 * 更新します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(MailAccountTable mailAccountTable) throws SampleException {
    	getHibernateTemplate().update(mailAccountTable);
    	getHibernateTemplate().flush();
    }
    
	/**
	 * 削除します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(MailAccountTable mailAccountTable) throws SampleException {
    	getHibernateTemplate().delete(mailAccountTable);
    	getHibernateTemplate().flush();
    }
}
