/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.entity.mail.MailAccountTable;



/**
 * データアクセスインターフェースです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public interface MailAccountTableDao {
	
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List findAll() throws SampleException;
    
	/**
	 * 登録します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailAccountTable mailAccountTable) throws SampleException;
    
	/**
	 * 更新します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(MailAccountTable mailAccountTable) throws SampleException;
    
	/**
	 * 削除します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(MailAccountTable mailAccountTable) throws SampleException;
}
