/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity.mail;

import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.jtp.entity.AuditableEntity;


/**
 * メールテーブルのエンティティクラスです。
 * 
 * @hibernate.class
 *  table="mail_table"
 *  mutable = "true"
 *  lazy = "false"
 * 
 * @hibernate.mapping
 *  auto-import = "true"
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class MailTable extends AuditableEntity {

    /** identifier field */
    private Integer id;

    /** nullable persistent field */
    private String from;

    /** nullable persistent field */
    private String to;

    /** nullable persistent field */
    private String subject;
    
    /** nullable persistent field */
    private String body;
    
    /** persistent field */
    private Set mailBccTables;

    /** persistent field */
    private Set mailCcTables;

    /** persistent field */
    private Set mailAttachTables;


    /** default constructor */
    public MailTable() {
    }

    /** minimal constructor */
    public MailTable(Integer id, Set mailBccTables, Set mailCcTables, Set mailAttachTables) {
        this.id = id;
        this.mailBccTables = mailBccTables;
        this.mailCcTables = mailCcTables;
        this.mailAttachTables = mailAttachTables;
    }

    /**
     * @hibernate.id
     *  generator-class="identity"
     *  column="id"
     */
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /** 
     * @hibernate.property
     *  column="from_address"
     */
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    /** 
     * @hibernate.property
     *  column="to_address"
     */
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    /** 
     * @hibernate.property
     *  column="subject"
     */
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    /** 
     * @hibernate.property
     *  column="body"
     *  length="65535"
     */
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    /**
     * @hibernate.set
     *   table = "mail_bcc_table"
     *   cascade = "all"
     *   lazy = "false"
     * @hibernate.collection-key
     *   column = "id"
     *   foreign-key = "fk_mail_bcc_table"
     * @hibernate.collection-one-to-many
     *   class="org.jtp.entity.mail.MailBccTable"
     */
    public Set getMailBccTables() {
        return this.mailBccTables;
    }

    public void setMailBccTables(Set mailBccTables) {
        this.mailBccTables = mailBccTables;
    }

    /**
     * @hibernate.set
     *   table = "mail_cc_table"
     *   cascade = "all"
     *   lazy = "false"
     * @hibernate.collection-key
     *   column = "id"
     *   foreign-key = "fk_mail_cc_table"
     * @hibernate.collection-one-to-many
     *   class="org.jtp.entity.mail.MailCcTable"
     */
    public Set getMailCcTables() {
        return this.mailCcTables;
    }

    public void setMailCcTables(Set mailCcTables) {
        this.mailCcTables = mailCcTables;
    }

    /**
     * @hibernate.set
     *   table = "mail_attach_table"
     *   cascade = "all"
     *   lazy = "false"
     * @hibernate.collection-key
     *   column = "id"
     *   foreign-key = "fk_mail_attach_table"
     * @hibernate.collection-one-to-many
     *   class="org.jtp.entity.mail.MailAttachTable"
     */
    public Set getMailAttachTables() {
        return this.mailAttachTables;
    }

    public void setMailAttachTables(Set mailAttachTables) {
        this.mailAttachTables = mailAttachTables;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", getId()).toString();
    }
}
