/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.tag;

import javax.servlet.jsp.JspException;

import org.jtp.web.bean.PagingBean;

/**
 * ページボタン出力カスタムタグクラス
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.2 $ $Date: 2007/04/04 16:30:46 $
 * @since 2.0 (Oct,26,2006)
 */
@SuppressWarnings("serial")
public class PageButtonTag extends BasePagingTag {

	/** 前ページであることを意味します */
	private static final String PREV = "前ページ";
	
	/** 次ページであることを意味します */
	private static final String NEXT = "次ページ";
	
	/**
	 * タグ生成
	 * @return 生成したタグ
	 * @throws JspException JSP例外
	 */
	protected String createTag() throws JspException {
		//改ページ設定情報を取得する
		PagingBean pagingBean = super.getPagingBean();
		
		StringBuffer result = new StringBuffer();
        
		result.append(createSpript() + "\n\n");
		
		result.append("<table border=\"0\">\n");
		result.append("<tr>\n");
		result.append("<td>\n");
		
		//前ページボタン出力
		if (pagingBean.getCurrent() > 1) {
			result.append(createButton(PREV, pagingBean.getPrev()));
		}
		
		result.append("</td>\n");
		result.append("<td>\n");
		
		//次ページボタン出力
		if (pagingBean.getCurrent() < pagingBean.getAll()) {
			result.append(createButton(NEXT, pagingBean.getNext()));
		}
		
		result.append("</td>\n");
		result.append("</tr>\n");
		result.append("</table>\n");
		
		return result.toString();
	}
	
	/**
	 * 改頁スクリプトを作成します。
	 */
	protected String createSpript() throws JspException {
		StringBuffer result = new StringBuffer();
		result.append("<script language=\"javascript\">\n");
		result.append("<!--\n");

		result.append("function doPaging(event, num) {\n");
		result.append("    var param = '?event=' + event + '&pageNum=' + num;\n");
		result.append("    document.forms['" + super.getActionFormName() + "'].action = '");
		result.append(super.getActionMappingURL());
		result.append("' + param;\n");
		result.append("    document.forms['" + super.getActionFormName() + "'].submit();\n");
		result.append("    return;\n");
		result.append("}\n");

		result.append("-->\n");
		result.append("</script>\n");

		return result.toString();
	}
	
	/**
	 * 送信タグの取得
	 * @return 送信タグ
	 */
	protected String createButton(String value, int page) {
		StringBuffer result = new StringBuffer();
		result.append("<input type=\"button\" name");
		result.append("=\"");
		result.append(value.equals(PREV) ? "prev" : "next");
		result.append("\"");
		result.append(" value=\"");
		result.append(value);
		result.append("\"");
		result.append(" onclick=\"");
		result.append("return doPaging('" + getEvent() + "', " + page + ")");
		result.append("\"");
		
		if (getStyleClass() != null) {
			result.append(" ");
			result.append("class");
			result.append("=\"");
			result.append(getStyleClass());
		}

		result.append("\">");
		return result.toString();		
	}
}
