/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.common;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jtp.SampleException;
import org.jtp.web.SessionManager;
import org.jtp.web.action.BaseAction;

/**
 * メニュー画面アクションクラスです。
 * 
 * @struts.action
 *  name="common/MenuForm"
 *  path="/common/menu"
 *  scope="request"
 *  validate="false"
 *  input="/common/menu.jsp"
 *  parameter="event"
 * @struts.action-forward
 *  name="success"
 *  path="/sample/search.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class MenuAction extends BaseAction {
	
	/**
	 * メニューアクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward success(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		request.getSession().setAttribute(SessionManager.COMMON_KEY, new SessionManager());
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
	
	/**
	 * タイムアウト確認を行なわないかを確認します
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	protected boolean isSkipTimeOut(HttpServletRequest request) {
		return true;
	}
}
