/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;
import org.jtp.SampleException;
import org.jtp.web.SessionManager;
import org.jtp.web.WebConstants;

/**
 * 基本アクションクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public abstract class BaseAction extends DispatchAction {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(BaseAction.class);
	
	/** 画面遷移イベント */
	protected static final String FORWARD_EVENT = WebConstants.FORWARD_EVENT;

	/** 画面遷移イベント名 */
	protected static final String FORWARD_SUCCESS 	= WebConstants.FORWARD_SUCCESS;
	/** 画面遷移イベント名 - メインメニューへ */
	protected static final String FORWARD_MENU		= WebConstants.FORWARD_MENU;
	/** 画面遷移イベント名 - 戻り時 */
	protected static final String FORWARD_CANCEL		= WebConstants.FORWARD_CANCEL;
	/** 画面遷移イベント名 - エラー時 */
	protected static final String FORWARD_FAIL		= WebConstants.FORWARD_FAIL;
	/** 画面遷移イベント名 - 共通エラー時 */
	protected static final String FORWARD_ERROR		= WebConstants.FORWARD_ERROR;
	
    /**
     * 画面アクション
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws Exception 例外
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
        
    	_log.info("execute start");
		
		ActionMessages errors = new ActionMessages();
		
		ActionForward forward = null;
		
		//セッションタイムアウトのチェック
		if (!isTimeOut(request)) {
			forward = mapping.findForward(FORWARD_ERROR);
			errors.add("timeout", new ActionMessage("msg.timeout"));
			addErrors(request, errors);
		}
		else {
			//アクション実行
			try {
				forward = super.execute(mapping, form, request, response);
			}
			catch (Exception e) {
				forward = mapping.findForward(FORWARD_ERROR);
				
				//エラーメッセージ
				errors.add("error", new ActionMessage("errors.msg", e.getMessage()));
				addErrors(request, errors);
			}
		}
		
		_log.info("forward=" + forward);
		_log.info("execute end");

		return forward;
    }
    
    /**
     * 戻るアクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward cancelled(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
    	return mapping.findForward(FORWARD_CANCEL);
    }

    /**
     * サーブレットコンテキスト取得
     * @return サーブレットコンテキスト
     */
    protected final ServletContext getServletContext() {
    	return this.getServlet().getServletContext();
    }
    
    /**
     * HTTPセッションを取得します
     * @param request  処理しているHTTPリクエスト
     * @return 処理しているHTTPセッション
     */
    protected final HttpSession getSession(HttpServletRequest request) {
    	return request.getSession();
    }
	
	/**
	 * セッションからセッション管理オブジェクトを取得する
	 * @param session  処理しているHTTPセッション
	 * @return セッション管理オブジェクト
	 */
	protected final SessionManager getCommonSession(HttpSession session) {
		return (SessionManager) session.getAttribute(SessionManager.COMMON_KEY);
	}
	
	/**
	 * タイムアウト確認を行なわないかを確認します
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	protected boolean isSkipTimeOut(HttpServletRequest request) {
		return false;
	}

	/**
	 * タイムアウトを確認します
	 * @param request  処理しているHTTPリクエスト
	 * @return true[続行]、false[タイムアウト]
	 */
	private boolean isTimeOut(HttpServletRequest request) {
		boolean result = true;
		
		if (isSkipTimeOut(request)) return true;
		
		if (getCommonSession(request.getSession(false)) == null) {
			result = false;
		}

		return result;
	}
}
