/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic.test;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.test.TestTableDao;
import org.jtp.entity.TestTable;



/** 
 * テストテーブル情報のサービスクラスです。
 * 
 * @spring.bean id="testTableService" 
 * @spring.property name="dao" ref="testTableDao"
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class TestTableServiceImpl implements TestTableService {

	/** テストテーブル情報DAO */
	private TestTableDao dao;

    /**
     * Setter Injection
     */
	public void setDao(TestTableDao dao) {
		this.dao = dao;
	}

	/**
	 * 検索します。
	 * @param testTable エンティティ
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List find(TestTable testTable) throws SampleException {
    	return dao.find(testTable);
    }
    
	/**
	 * 登録します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTable testTable) throws SampleException {
    	dao.save(testTable);
    }

	/**
	 * 更新します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(TestTable testTable) throws SampleException {
    	dao.update(testTable);
    }
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(TestTable testTable) throws SampleException {
    	dao.delete(testTable);
    }
}
