/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.common.util;


/**
 * 文字列関連のユーティリティクラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public final class StringUtils {


    /**
     * コンストラクタ（外部からのインスタンス生成を許可しない）
     */
    private StringUtils() {}
    
    /**
     * 文字列配列を指定した区切り文字列に変換します
     * @param args 文字列配列
     * @param delimiter 区切り文字列
     * @return 指定した区切り文字列
     */
    public static String toDelimitedString(Object[] args, String delimiter) {
		StringBuffer ret = new StringBuffer();
		
		if (args == null) return ret.toString();
		
		for (int i = 0; i < args.length; i++) {
			if (args[i] == null) continue;
			if (args[i].equals("")) continue;
			ret.append(args[i]);
			if (i != args.length - 1) {
				ret.append(delimiter);
			}
		}
		//最後が区切り文字の場合、取り除く
		if (ret.toString().endsWith(delimiter)) {
			ret.deleteCharAt(ret.length() - 1);
		}
		return ret.toString();
    }

    /**
     * 文字列配列をカンマ区切り文字列に変換します
     * @param args 文字列配列
     * @return カンマ区切り文字列
     */
    public static String toCommaDelimitedString(Object[] args) {
    	return toDelimitedString(args, ",");
    }

    /**
     * 文字列配列をタブ区切り文字列に変換します
     * @param args 文字列配列
     * @return タブ区切り文字列
     */
    public static String toTabDelimitedString(Object[] args) {
    	return toDelimitedString(args, "\t");
    }
}
