/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.tag;

import javax.servlet.jsp.JspException;

import org.jtp.web.bean.PagingBean;


/**
 * ページ番号出力カスタムタグクラス
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.1 $ $Date: 2007/04/06 07:22:14 $
 * @since 2.0 (Oct,26,2006)
 */
@SuppressWarnings("serial")
public class PageNumberTag extends BasePagingTag {

	/**
	 * タグ生成
	 * @return 生成したタグ
	 * @throws JspException JSP例外
	 */
	protected String createTag() throws JspException {
		//改ページ設定情報を取得する
		PagingBean pagingBean = super.getPagingBean();

		//スタイル
		String startStyle = "";
		String endStyle = "";
		if ((getStyleClass() != null) && (!getStyleClass().equals(""))) {
			startStyle = "<span class=\"" + getStyleClass() + "\">";
			endStyle = "</span>";
		}
		
		StringBuffer result = new StringBuffer();
		result.append("頁数 :");
		result.append(startStyle);
		result.append(pagingBean.getCurrent());
		result.append(endStyle);
		result.append("/");
		result.append(startStyle);
		result.append(pagingBean.getAll());
		result.append(endStyle);
		result.append("頁");
		result.append("&nbsp;&nbsp;&nbsp;");
		result.append("【ヒット数 :");
		result.append(startStyle + pagingBean.getCount() + endStyle + "件】");
		
		return result.toString();
	}
}
