/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;

import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

/**
 * 常にセッションに保持する情報を管理する為の基本クラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public abstract class BaseSession implements HttpSessionBindingListener {
	
	/** セッション開始時間 */
	private long startTime = 0;
	/** セッションのタイムアウト */
	private int timeout = 0;
	/** セッションの終了時間 */
	private long endTime = 0;
	/** セッションID */
	private String sessionId = null;

	/**
	 * セッションに結びつけられようとしていることをオブジェクトに通知し、 セッションを識別します
	 * @param arg0 セッションを識別するためのイベントオブジェクト
	 */
	public final void valueBound(HttpSessionBindingEvent arg0) {
		//セッション開始時間の設定
		if (this.startTime == 0) {
			//セッションのタイムアウト時間(ミリ秒)設定
			this.timeout = arg0.getSession().getMaxInactiveInterval();
			//セッション終了時間の設定
			this.endTime = this.startTime + this.timeout;
			//セッションID設定
			this.sessionId = arg0.getSession().getId();
		}
	}

	/**
	 * セッションから取り外されようとしていることをオブジェクトに通知し、 セッションを識別します
	 * @param arg0 セッションを識別するためのイベントオブジェクト
	 */
	public void valueUnbound(HttpSessionBindingEvent arg0) {}

	/**
	 * セッション開始時間の取得
	 * @return セッション開始時間
	 */
	public final long getStartTime() {
		return this.startTime;
	}
	
	/**
	 * セッションのタイムアウト時間(ミリ秒)の取得
	 * @return セッションのタイムアウト時間(ミリ秒)
	 */
	public final int getTimeOut() {
		return this.timeout;
	}
	
	/**
	 * セッション終了時間の取得
	 * @return セッション終了時間
	 */
	public final long getEndTime() {
		return this.endTime;
	}
	
	/**
	 * セッションIDの取得
	 * @return セッションID
	 */
	public final String getSessionId() {
		return this.sessionId;
	}
}
