/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity;

import java.util.Date;

/**
 * テストテーブルのエンティティクラスです。
 * 
 * @jdo.persistence-capable
 *   identity-type = "application"
 *   table = "TEST_TABLE"
 * 
 * @jdo.query
 *   name = "testTableList"
 *   language="javax.jdo.query.JDOQL"
 *   query = "select from org.jtp.entity.TestTable
 *             where (:id < 0 || id == :id)
 *                && (:hoge1 == null || hoge1.like(:hoge1))
 *                && (:hoge2 == null || hoge2.like(:hoge2))
 *                && (:hoge3 == null || hoge3.like(:hoge3))
 *            order by id ascending
 *           "
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class TestTable implements Auditable {

	/**
	 * @jdo.field
	 *   primary-key="true"
	 *   value-strategy="autoassign"
	 * @jdo.column
	 *   name="id"
	 *   length="10"
     *   jdbc-type="INTEGER"
	 */
	private Integer id;

	/**
	 * @jdo.field
	 *   persistence-modifier="persistent"
	 * @jdo.column
	 *   name="hoge1"
	 *   length="50"
	 *   jdbc-type="VARCHAR"
	 */
	private String hoge1;

	/**
	 * @jdo.field
	 *   persistence-modifier="persistent"
	 * @jdo.column
	 *  name="hoge2"
	 *  length="50"
	 *  jdbc-type="VARCHAR"
	 */
	private String hoge2;

	/**
	 * @jdo.field
	 *   persistence-modifier="persistent"
	 * @jdo.column
	 *   name="hoge3"
	 *   length="50"
	 *   jdbc-type="VARCHAR"
	 */
	private String hoge3;

	/**
	 * @jdo.field
	 *   persistence-modifier="persistent"
	 * @jdo.column
	 *   name="create_date"
	 *   jdbc-type="TIMESTAMP"
	 */
	private Date createDate;

	/**
	 * @jdo.field
	 *   persistence-modifier="persistent"
	 * @jdo.column
	 *   name="update_date"
	 *   jdbc-type="TIMESTAMP"
	 */
	private Date updateDate;

	/** default constructor */
	public TestTable() {
	}

	/** minimal constructor */
	public TestTable(Integer id) {
		this.id = id;
	}

	public Integer getId() {
		return this.id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getHoge1() {
		return this.hoge1;
	}

	public void setHoge1(String hoge1) {
		this.hoge1 = hoge1;
	}

	public String getHoge2() {
		return this.hoge2;
	}

	public void setHoge2(String hoge2) {
		this.hoge2 = hoge2;
	}

	public String getHoge3() {
		return this.hoge3;
	}

	public void setHoge3(String hoge3) {
		this.hoge3 = hoge3;
	}

	/**
	 * エンティティの登録日時を取得します。
	 * @return エンティティの登録日時
	 */
	public Date getCreateDate() {
		return this.createDate;
	}

	/**
	 * エンティティの登録日時を設定します。
	 * @param createDate エンティティの登録
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * エンティティの更新日時を取得します。
	 * @return エンティティの更新日時
	 */
	public Date getUpdateDate() {
		return this.updateDate;
	}

	/**
	 * エンティティの更新日時を設定します。
	 * @param updateDate エンティティの更新日時
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
}
