/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.jtp.web.util.FacesUtils;


/**
 * カタカナバリデータクラスです。
 * 
 * @jsf.validator
 *  name="katakana"
 *  
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */ 
public class KatakanaValidator implements Validator {

	/** バリデータID */
	private final static String HIRAGANA_VALIDATE_ID = "error.validator.KATAKANA";

	/**
	 * 文字列がカタカナであるかどうかチェックする
	 * @param context コンテキスト
	 * @param component コンポーネント
	 * @param value 入力された値
	 */
    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		if (!value.toString().matches("^\\p{InKatakana}*$")) {
            String text = FacesUtils.formatMessage(HIRAGANA_VALIDATE_ID);
            throw new ValidatorException(
                    new FacesMessage(FacesMessage.SEVERITY_ERROR, text, null));
		}
	}
}
