/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * 登録日時、更新日時を提供するインターフェースです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public interface Auditable extends Serializable {

    /**
     * エンティティの登録日時を取得します。
     * @return エンティティの登録日時
     */
    public Date getCreateDate();

    /**
     * エンティティの登録日時を設定します。
     * @param createDate エンティティの登録
     */
    public void setCreateDate(Date createDate);

    /**
     * エンティティの更新日時を取得します。
     * @return エンティティの更新日時
     */
    public Date getUpdateDate();

    /**
     * エンティティの更新日時を設定します。
     * @param updateDate エンティティの更新日時
     */
    public void setUpdateDate(Date updateDate);
}
