/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;

import java.io.Serializable;
import java.util.HashMap;

/**
 * 常にセッションに保持する情報を管理するクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public final class SessionManager extends BaseSession implements Serializable {

	/** セッション格納キー */
	public static final String COMMON_KEY = "COMMON_KEY";
	
	/** セッション管理マップ */
	private HashMap sessionMap = null;

	/**
	 * コンストラクタ 
	 */
	public SessionManager() {
		super();
		this.sessionMap = new HashMap();
	}

	/**
	 * セッションデータ設定
	 * @param key キー
	 * @param value オブジェクト
	 */
	@SuppressWarnings("unchecked")
	public void setAttribute(String key, Object value) {
		this.sessionMap.put(key, value);
	}

	/**
	 * セッションデータ取得
	 * @param key キー
	 * @return オブジェクト
	 */
	public Object getAttribute(String key) {
		return this.sessionMap.get(key);
	}
	
	/**
	 * セッションデータ削除
	 * @param key キー
	 */
	public void removeAttribute(String key) {
		this.sessionMap.remove(key);
	}
	
	/**
	 * クリア
	 */
	public void clear() {
		sessionMap.clear();
	}
}
