/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.menu;

import java.io.Serializable;

import org.jtp.entity.TestTable;
import org.jtp.web.WebContext;



/**
 * メニュー画面のバッキングビーンクラスです。
 * 
 * @jsf.bean
 * name = "menuBean"
 * scope = "session"
 * 
 * @jsf.navigation 
 *  result = "search" 
 *  from = "/jsp/common/menu.jsp" 
 *  to   = "/sample/search.tiles" 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class MenuBean implements Serializable {

    public static final String ATTRIBUTE_NAME = "menuBean";

    /** テストテーブルのエンティティ */
    private TestTable testTable;
    
    
    public MenuBean() {
    	testTable = new TestTable();
    }
    
	/**
	 * 
	 * @return
	 */
	public TestTable getTestTable() {
		return testTable;
	}

	/**
	 * 
	 * @param testTable
	 */
	public void setTestTable(TestTable testTable) {
		this.testTable = testTable;
	}

	/**
     * セッションにバインディングされているオブジェクトを返します。
     * @return バッキングビーン
     */
    public static MenuBean getBindingBean() {
        return (MenuBean) WebContext.getBindingBean(ATTRIBUTE_NAME);
    }
}
