package net.bakingpowder.mDNSrelay.Server;

import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
//import java.util.Stack;
import java.io.IOException;

public class MDNSrelay_serviceCTRL implements Runnable {
	final static String MDNS_GROUP = "224.0.0.251";
	final static int MDNS_PORT = 5353;
	
	private CollectAndSend2Client cc;
	private RecieveFromClientAndBroadcast rf;
	private ServerSocket mainSocket = null;
	private MulticastSocket ms;
	private boolean stopper = false;
	
	public MDNSrelay_serviceCTRL(int portNumber) throws Exception {
		mainSocket = new ServerSocket(portNumber);
		ms = new MulticastSocket(MDNS_PORT);
		InetAddress iams = InetAddress.getByName(MDNS_GROUP);
		ms.joinGroup(iams);
	}

	
	public void run() {
		System.out.println("[MDNSrelay Server ver " + net.bakingpowder.tool.Misc.VERSION + "] since Apl.2005");
		System.out.println("Waiting Connection from MDNSrelay Client.");

		while (!stopper) {
			Socket newSocket;
			try {
				newSocket = mainSocket.accept();
				System.out.println("Connection has been accepted.");
				
				rf = new RecieveFromClientAndBroadcast(newSocket);
				Thread th2 = new Thread(rf);
				th2.start();
				
				cc = new CollectAndSend2Client(ms,newSocket);
				Thread th = new Thread(cc);
				th.start();
				

				
			} catch (IOException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}

		}
		
			try {
				mainSocket.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		
	}
}