package net.bakingpowder.mDNSrelay.Server;

import java.net.DatagramPacket;
//import java.net.InetAddress;
//import java.net.InetAddress;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CollectAndSend2Client implements Runnable {
	private Socket srcSocket, destSocket;

	private OutputStream srcOut;

	private InputStream srcIn;

	final static int BUFFER_SIZE = 4096;

	MulticastSocket ms = null;

	byte[] buffer = new byte[BUFFER_SIZE];

	//java.util.Stack st;

	public CollectAndSend2Client(MulticastSocket ms, Socket ss) {
		srcSocket = ss;
		//this.st = st;
		try {
			this.ms = ms;
			srcOut = ss.getOutputStream();

		} catch (UnknownHostException e) {
			System.out.println("I can't get host address by name");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void run() {
		while (true) {
			try {

				DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
				ms.receive(dp);
				int gttl = ms.getTimeToLive();

				if (dp.getAddress().equals(InetAddress.getLocalHost())) {
					//ignore
				} else {

					if ((gttl == 1)) {
						srcOut.write(buffer);
					}
				}

			} catch (IOException e) {
				return;
			}
		}
	}
}