package net.bakingpowder.mDNSrelay.Client;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CollectAndSend2Server implements Runnable {
	private Socket srcSocket, destSocket;

	private OutputStream srcOut;

	private InputStream srcIn;

	final static String MDNS_GROUP = "224.0.0.251";

	final static int MDNS_PORT = 5353;

	final static int BUFFER_SIZE = 4096;

	MulticastSocket ms = null;

	InetAddress iams = null;

	byte[] buffer = new byte[BUFFER_SIZE];

	public CollectAndSend2Server(Socket ss) {
		srcSocket = ss;
		try {
			ms = new MulticastSocket(MDNS_PORT);
			iams = InetAddress.getByName(MDNS_GROUP);
			ms.joinGroup(iams);
			srcOut = ss.getOutputStream();

		} catch (UnknownHostException e) {
			System.out.println("I can't get host address by name");
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	private synchronized void waiting() {
		try {
			this.wait();
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}
	}

	public void run() {
		while (true) {
			try {

				try {
					Thread.sleep(1000);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
				}

				DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
				ms.receive(dp);
				int gttl = ms.getTimeToLive();
				if (dp.getAddress().equals(InetAddress.getLocalHost())) {
					//ignore
				} else {
					if ((gttl == 1)) {
						srcOut.write(buffer);
					}
				}

			} catch (IOException e) {
				return;
			}
		}
	}
}