/*
 * Decompiled with CFR 0.152.
 */
package net.bakingpowder.mDNSrelay.Client;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import net.bakingpowder.mDNSrelay.Client.CollectAndSend2Server;
import net.bakingpowder.tool.Misc;

public class MDNSrelay_clientCTRL
implements Runnable {
    static final String MDNS_GROUP = "224.0.0.251";
    static final int MDNS_PORT = 5353;
    static final int BUFFER_SIZE = 1024;
    private String destHost = null;
    private String destRecieveTCPRelayAddress = null;
    private int destRecieveTCPRelayPort;
    private int destPortNumber;
    private boolean stopper = false;
    MulticastSocket ms;
    InetAddress iams;

    public MDNSrelay_clientCTRL(String destRecieveTCPRelayAddress, int destRecieveTCPRelayPort, String ni) throws Exception {
        this.destRecieveTCPRelayAddress = destRecieveTCPRelayAddress;
        this.destRecieveTCPRelayPort = destRecieveTCPRelayPort;
        this.ms = new MulticastSocket(5353);
        this.ms.setNetworkInterface(NetworkInterface.getByName(ni));
        this.iams = InetAddress.getByName(MDNS_GROUP);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        System.out.println("[MDNSrelay Client ver " + Misc.VERSION + "] since Apl.2005");
        Socket destSocket = null;
        try {
            destSocket = new Socket(this.destRecieveTCPRelayAddress, this.destRecieveTCPRelayPort);
        }
        catch (ConnectException e1) {
            System.err.println("[err]Connection refused");
            return;
        }
        catch (UnknownHostException e1) {
            System.err.println("[err]Server is Unknownhost");
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("Connection Completed.");
        CollectAndSend2Server cas2s = new CollectAndSend2Server(destSocket);
        Thread th = new Thread(cas2s);
        th.start();
        try {
            InputStream srcIn = destSocket.getInputStream();
            byte[] buffer = new byte[4096];
            int i = 0;
            int totalbytes = 0;
            int bytesRead = 0;
            try {
                while (true) {
                    if ((bytesRead = srcIn.read(buffer, 0, 1024)) == -1) {
                        return;
                    }
                    System.out.print("forward packets:" + ++i + " packets\t");
                    System.out.print("forward Total:" + (totalbytes += bytesRead) + "bytes");
                    System.out.print("\r");
                    DatagramPacket dp = new DatagramPacket(buffer, buffer.length, this.iams, 5353);
                    this.ms.setTimeToLive(255);
                    this.ms.send(dp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(0);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

