package net.bakingpowder.mDNSrelay.Client;

import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.io.IOException;
import java.io.InputStream;

public class MDNSrelay_clientCTRL implements Runnable {

	final static String MDNS_GROUP = "224.0.0.251";
	final static int MDNS_PORT = 5353;
	final static int BUFFER_SIZE = 1024;

	
	//q̏
	private String destHost = null;
	private String destRecieveTCPRelayAddress = null;
	private int destRecieveTCPRelayPort, destPortNumber;
	private boolean stopper = false;

	//}`LXg\Pbg
	MulticastSocket ms;

	/**
	 * ݒp̃RXgN^
	 * 
	 * @param portNumber
	 * @param destRecieveTCPRelayAddress
	 * @param destRecieveTCPRelayPort
	 * @throws Exception
	 */
public MDNSrelay_clientCTRL(String destRecieveTCPRelayAddress,int destRecieveTCPRelayPort)
			throws Exception {
		this.destRecieveTCPRelayAddress = destRecieveTCPRelayAddress;
		this.destRecieveTCPRelayPort = destRecieveTCPRelayPort;		
		ms = new MulticastSocket(MDNS_PORT);
		iams = InetAddress.getByName(MDNS_GROUP);
	}

	InetAddress iams;

	public void run() {
		System.out.println("[MDNSrelay Client ver 0.02] since Apl.2005");
		Socket destSocket = null;
		try {
			destSocket = new Socket(destRecieveTCPRelayAddress,
					destRecieveTCPRelayPort);
		} catch (ConnectException e1){
			System.err.println("[err]Connection refused");
			return;
		} catch (UnknownHostException e1) {
			System.err.println("[err]Server is Unknownhost");
			return;
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		
		System.out.println("Connection Completed.");
		
		java.util.Stack st = new java.util.Stack();
		
		
		CollectAndSend2Server cas2s = new CollectAndSend2Server(destSocket,st);
		Thread th = new Thread(cas2s);
		th.start();
		
		try {
			InputStream srcIn = destSocket.getInputStream();
			byte[] buffer = new byte[4096];

			int i=0;
			int totalbytes = 0;
			int bytesRead = 0;
			while (true) {
				try {
					if ((bytesRead = srcIn.read(buffer, 0, BUFFER_SIZE)) == -1){break;}
					
					i++;
					totalbytes = totalbytes + bytesRead;
					System.out.print("forward packets:" + i + " packets\t");
					System.out.print("forward Total:" + totalbytes + "bytes");
					System.out.print("\r");
					
					DatagramPacket dp = new DatagramPacket(buffer, buffer.length,iams,MDNS_PORT);
					ms.setTimeToLive(254);
					st.push(buffer);
					//ms.setLoopbackMode(true);
					
					ms.send(dp);
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
					
		} catch (UnknownHostException e) {
			e.printStackTrace();
			System.exit(0);
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(0);
		}

	}
}