/*
 * Decompiled with CFR 0.152.
 */
package net.bakingpowder.mDNSrelay.Client;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Stack;
import net.bakingpowder.mDNSrelay.Client.CollectAndSend2Server;

public class MDNSrelay_clientCTRL
implements Runnable {
    static final String MDNS_GROUP = "224.0.0.251";
    static final int MDNS_PORT = 5353;
    static final int BUFFER_SIZE = 1024;
    private String destHost = null;
    private String destRecieveTCPRelayAddress = null;
    private int destRecieveTCPRelayPort;
    private int destPortNumber;
    private boolean stopper = false;
    MulticastSocket ms;
    InetAddress iams;

    public MDNSrelay_clientCTRL(String destRecieveTCPRelayAddress, int destRecieveTCPRelayPort) throws Exception {
        this.destRecieveTCPRelayAddress = destRecieveTCPRelayAddress;
        this.destRecieveTCPRelayPort = destRecieveTCPRelayPort;
        this.ms = new MulticastSocket(5353);
        this.iams = InetAddress.getByName(MDNS_GROUP);
    }

    public void run() {
        System.out.println("[MDNSrelay Client ver 0.02] since Apl.2005");
        Socket destSocket = null;
        try {
            destSocket = new Socket(this.destRecieveTCPRelayAddress, this.destRecieveTCPRelayPort);
        }
        catch (ConnectException e1) {
            System.err.println("[err]Connection refused");
            return;
        }
        catch (UnknownHostException e1) {
            System.err.println("[err]Server is Unknownhost");
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("Connection Completed.");
        Stack<byte[]> st = new Stack<byte[]>();
        CollectAndSend2Server cas2s = new CollectAndSend2Server(destSocket, st);
        Thread th = new Thread(cas2s);
        th.start();
        try {
            InputStream srcIn = destSocket.getInputStream();
            byte[] buffer = new byte[4096];
            int i = 0;
            int totalbytes = 0;
            int bytesRead = 0;
            while (true) {
                try {
                    bytesRead = srcIn.read(buffer, 0, 1024);
                    if (bytesRead != -1) {
                        System.out.print("forward packets:" + ++i + " packets\t");
                        System.out.print("forward Total:" + (totalbytes += bytesRead) + "bytes");
                        System.out.print("\r");
                        DatagramPacket dp = new DatagramPacket(buffer, buffer.length, this.iams, 5353);
                        this.ms.setTimeToLive(254);
                        st.push(buffer);
                        this.ms.send(dp);
                    }
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

