package net.bakingpowder.jspl.tcprelay.buffering;

import java.util.LinkedList;

public class BoundedQueue {
    LinkedList ls;
    int limit;
    
    BoundedQueue(int size){
        this.limit = size;
        ls = new LinkedList();
    }

    public synchronized boolean enqueue(Object o){
        if (ls.size() >= limit){
            return false; 
        } else {
            ls.addLast(o);
            return true;
        }
    }
    
    public synchronized Object dequeue(){
        Object o = ls.getFirst();
        ls.removeFirst();
        return o;
    }
    
    public boolean isEmpty(){
        return ls.isEmpty();
    }
}
