/*
 * Decompiled with CFR 0.152.
 */
package net.bakingpowder.jspl.tcprelay.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.bakingpowder.jspl.tcprelay.standard.Input2Output;
import net.bakingpowder.jspl.tcprelay.standard.TCPRelay;

public class ConnectControl
implements Runnable {
    private boolean connectionClosed = false;
    private InputStream destIn;
    private InputStream srcIn;
    private OutputStream srcOut;
    private OutputStream destOut;
    private Input2Output src2dst;
    private Input2Output dst2src;
    private TCPRelay myp;
    private Socket srcSocket;
    private Socket destSocket;
    private String destHost;
    private int destPort;

    public ConnectControl(Socket s, String destHost, int destPort) {
        this.srcSocket = s;
        this.destHost = destHost;
        this.destPort = destPort;
        try {
            this.srcIn = s.getInputStream();
            this.srcOut = s.getOutputStream();
            Thread t = new Thread(this);
            t.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void ThreadArrivedEnd(Input2Output a) {
        if (this.connectionClosed) {
            return;
        }
        this.closeSrc();
        this.closeDest();
        this.connectionClosed = true;
    }

    private void closeDest() {
        try {
            this.destIn.close();
            this.destOut.close();
            this.destSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSrc() {
        try {
            this.srcIn.close();
            this.srcOut.close();
            this.srcSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean connectToDest() {
        try {
            this.destSocket = new Socket(this.destHost, this.destPort);
            this.destIn = this.destSocket.getInputStream();
            this.destOut = this.destSocket.getOutputStream();
        }
        catch (Exception e) {
            System.err.println("[Proxy Connection Error]");
            return false;
        }
        return true;
    }

    public void stopd() {
        this.src2dst.stopd();
        this.dst2src.stopd();
        try {
            this.destIn.close();
            this.destOut.close();
            this.srcIn.close();
            this.srcOut.close();
            this.destSocket.close();
            this.srcSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        if (!this.connectToDest()) {
            this.closeSrc();
        } else {
            this.src2dst = new Input2Output(this.srcIn, this.destOut, this);
            this.dst2src = new Input2Output(this.destIn, this.srcOut, this);
        }
    }
}

