/*
 * Decompiled with CFR 0.152.
 */
package net.bakingpowder.jspl.tcprelay.distributed.sendRelay;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.bakingpowder.jspl.tcprelay.distributed.sendRelay.SendConnectControl;

public class SendTCPRelay
implements Runnable {
    private String destHost = null;
    private String destRecieveTCPRelayAddress = null;
    private ServerSocket mainSocket = null;
    private int portNumber;
    private int destRecieveTCPRelayPort;
    private int destPortNumber;
    private boolean stopper = false;
    private SendConnectControl cc;

    public SendTCPRelay(int portNumber, String destRecieveTCPRelayAddress, int destRecieveTCPRelayPort, String destHost, int destPortNumber) throws Exception {
        this.portNumber = portNumber;
        this.destRecieveTCPRelayAddress = destRecieveTCPRelayAddress;
        this.destRecieveTCPRelayPort = destRecieveTCPRelayPort;
        this.destHost = destHost;
        this.destPortNumber = destPortNumber;
        this.mainSocket = new ServerSocket(portNumber);
    }

    public synchronized void setStopper(boolean stopper) {
        if (this.cc != null) {
            this.cc.stopd();
        }
        this.stopper = stopper;
        try {
            this.mainSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        while (!this.stopper) {
            try {
                Socket newSocket = this.mainSocket.accept();
                Socket destSocket = new Socket(this.destRecieveTCPRelayAddress, this.destRecieveTCPRelayPort);
                System.out.println("SENDPROXY:Socket has been accepted!):" + this.destPortNumber);
                this.cc = new SendConnectControl(newSocket, destSocket, this.destHost, this.destPortNumber);
            }
            catch (IOException e) {
                System.out.println("IOException!!!");
            }
        }
        System.out.println("Proxy(" + this.portNumber + ":" + this.destHost + ":" + this.destPortNumber + ") is stopped.");
        try {
            this.mainSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

