/*
 * Decompiled with CFR 0.152.
 */
package net.bakingpowder.jspl.tcprelay.distributed.sendRelay;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.bakingpowder.jspl.tcprelay.distributed.sendRelay.SendInput2Output;

public class SendConnectControl
implements Runnable {
    private boolean connectionClosed = false;
    private InputStream destIn;
    private InputStream srcIn;
    private OutputStream srcOut;
    private OutputStream destOut;
    private SendInput2Output src2dst;
    private SendInput2Output dst2src;
    private Socket srcSocket;
    private Socket destSocket;
    private String destHost;
    private int destPort;

    public SendConnectControl(Socket ss, Socket ds, String destHost, int destPortNumber) {
        this.srcSocket = ss;
        this.destSocket = ds;
        this.destHost = destHost;
        this.destPort = destPortNumber;
        try {
            this.srcIn = ss.getInputStream();
            this.srcOut = ss.getOutputStream();
            this.destIn = ds.getInputStream();
            this.destOut = ds.getOutputStream();
            this.destOut.write(destHost.getBytes().length);
            this.destOut.write(destHost.getBytes());
            this.destOut.write(new Integer(destPortNumber).toString().getBytes().length);
            this.destOut.write(new Integer(destPortNumber).toString().getBytes());
            Thread t = new Thread(this);
            t.start();
        }
        catch (IOException e) {
            System.err.println("[Proxy Connection Error]");
            e.printStackTrace();
        }
    }

    public synchronized void ThreadArrivedEnd(SendInput2Output a) {
        if (this.connectionClosed) {
            return;
        }
        this.closeSrc();
        this.closeDest();
        this.connectionClosed = true;
    }

    private void closeDest() {
        try {
            this.destIn.close();
            this.destOut.close();
            this.destSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSrc() {
        try {
            this.srcIn.close();
            this.srcOut.close();
            this.srcSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopd() {
        if (this.src2dst == null) {
            this.src2dst.stopd();
        }
        if (this.dst2src == null) {
            this.dst2src.stopd();
        }
    }

    public void run() {
        this.src2dst = new SendInput2Output(this.srcIn, this.destOut, this);
        this.dst2src = new SendInput2Output(this.destIn, this.srcOut, this);
    }
}

