/*
 * Decompiled with CFR 0.152.
 */
package net.bakingpowder.jspl.tcprelay.distributed.recieveRelay;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.bakingpowder.jspl.tcprelay.distributed.recieveRelay.RecieveInput2Output;

public class RecieveConnectControl
implements Runnable {
    private boolean connectionClosed = false;
    private InputStream destIn;
    private InputStream srcIn;
    private OutputStream srcOut;
    private OutputStream destOut;
    private RecieveInput2Output src2dst;
    private RecieveInput2Output dst2src;
    private Socket srcSocket;
    private Socket destSocket;
    private String destHost;
    private int destPort;
    private boolean errOr = false;

    public RecieveConnectControl(Socket ss) {
        this.srcSocket = ss;
        try {
            this.srcIn = ss.getInputStream();
            this.srcOut = ss.getOutputStream();
            byte[] destAddressByte = new byte[30];
            int destAddressLength = this.srcIn.read();
            this.srcIn.read(destAddressByte, 0, destAddressLength);
            this.destHost = new String(destAddressByte);
            this.destHost = this.destHost.substring(0, destAddressLength);
            byte[] destPortByte = new byte[6];
            int destPortLength = this.srcIn.read();
            this.srcIn.read(destPortByte, 0, destPortLength);
            String destPortString = new String(destPortByte);
            destPortString = destPortString.substring(0, destPortLength);
            this.destPort = Integer.parseInt(destPortString);
            System.out.println("Address:" + this.destHost);
            System.out.println("Port:" + this.destPort);
            Socket ds = new Socket(this.destHost, this.destPort);
            this.destIn = ds.getInputStream();
            this.destOut = ds.getOutputStream();
            Thread t = new Thread(this);
            t.start();
        }
        catch (IOException e) {
            System.err.println("[Proxy Connection Error]");
            e.printStackTrace();
        }
        catch (StringIndexOutOfBoundsException e) {
            this.errOr = true;
            this.closeSrc();
        }
    }

    public synchronized void ThreadArrivedEnd(RecieveInput2Output a) {
        if (this.connectionClosed) {
            return;
        }
        this.closeSrc();
        this.closeDest();
        this.connectionClosed = true;
    }

    private void closeDest() {
        try {
            this.destIn.close();
            this.destOut.close();
            this.destSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSrc() {
        try {
            this.srcIn.close();
            this.srcOut.close();
            this.srcSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopd() {
        if (this.src2dst == null) {
            this.src2dst.stopd();
        }
        if (this.dst2src == null) {
            this.dst2src.stopd();
        }
    }

    public void run() {
        if (!this.errOr) {
            this.src2dst = new RecieveInput2Output(this.srcIn, this.destOut, this);
            this.dst2src = new RecieveInput2Output(this.destIn, this.srcOut, this);
        }
    }
}

