package net.bakingpowder.tmiz.simpleproxy.base;

import java.net.ServerSocket;
import java.net.Socket;
import java.io.IOException;

/**
 * @author Tomoo D. Mizukami/JAIST/Softbank Publishing Inc.
 *
 * This Library provide you a simple and light-weight proxy solution.
 */
public class MyProxy implements Runnable {
	private String destHost = null;
	private ServerSocket mainSocket = null;
	private int portNumber, destPortNumber;
	private boolean stopper = false;
	
	/**
	 * @param portNumber
	 *            Listening Local PortNumber
	 * @param destHost
	 *            Destination Host Address
	 * @param destPortNumber
	 *            Destination Host PortNumber
	 * @throws Exception
	 */
	public MyProxy(int portNumber, String destHost, int destPortNumber)
			throws Exception {
		this.portNumber = portNumber;
		this.destHost = destHost;
		this.destPortNumber = destPortNumber;

		mainSocket = new ServerSocket(portNumber);
	}

	/**
	 * Let Proxy Service start.
	 */
	public void service_start() {
		while (true) {
			try {
				Socket newSocket = mainSocket.accept();
				new ConnectControl(newSocket, destHost, destPortNumber);

			} catch (IOException e) {
				//ignore//
			}
		}
	}
	
	/**
	 * @param stopper The stopper to set.
	 */
	public synchronized void setStopper(boolean stopper) {
		this.stopper = stopper;
	}
		
	public void run() {
		while (!stopper) {
			try {
				Socket newSocket = mainSocket.accept();
				new ConnectControl(newSocket, destHost, destPortNumber);

			} catch (IOException e) {
				//ignore//
			}
		}
		System.out.println("Proxy(" + portNumber + ":" + destHost + ":" + destPortNumber + ") is stopped.");	
	}
}