/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hsqldb.util.ConnectionDialogSwing;

public class TransferSwing
extends JApplet
implements WindowListener,
ActionListener,
ListSelectionListener,
ItemListener {
    Connection cSource;
    Connection cTarget;
    DatabaseMetaData dSourceMeta;
    DatabaseMetaData dTargetMeta;
    Statement sSourceStatement;
    Statement sTargetStatement;
    JFrame fMain;
    Image imgEmpty;
    Table tCurrent;
    int iMaxRows;
    Vector tTable;
    JList lTable;
    DefaultListModel lTableModel;
    JTextField tSourceTable;
    JTextField tDestTable;
    JTextField tDestDrop;
    JTextField tDestCreate;
    JTextField tDestDelete;
    JTextField tSourceSelect;
    JTextField tDestInsert;
    JCheckBox cTransfer;
    JCheckBox cDrop;
    JCheckBox cCreate;
    JCheckBox cDelete;
    JCheckBox cInsert;
    JButton bStart;
    Hashtable hTypes;
    JTextField tMessage;
    static boolean bMustExit;
    String sLast;

    public void init() {
        TransferSwing transferSwing = new TransferSwing();
        transferSwing.main();
    }

    public static void work() {
        TransferSwing transferSwing = new TransferSwing();
        transferSwing.main();
    }

    public static void main(String[] stringArray) {
        ((Hashtable)System.getProperties()).put("sun.java2d.noddraw", "true");
        bMustExit = true;
        TransferSwing.work();
    }

    void main() {
        this.fMain = new JFrame("Hypersonic Transfer Tool");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        ((Frame)this.fMain).setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        ((Component)this.fMain).setSize(640, 480);
        this.fMain.getContentPane().add("Center", this);
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = new String[]{"Insert 10 rows only", "Insert 1000 rows only", "Insert all rows", "Close"};
        JMenu jMenu = new JMenu("Options");
        this.addMenuItems(jMenu, stringArray);
        jMenuBar.add(jMenu);
        this.fMain.setJMenuBar(jMenuBar);
        this.initGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        ((Component)this.fMain).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this.fMain).setVisible(true);
        this.cSource = ConnectionDialogSwing.createConnection(this.fMain, "Source Database");
        if (this.cSource == null) {
            return;
        }
        try {
            this.dSourceMeta = this.cSource.getMetaData();
            this.sSourceStatement = this.cSource.createStatement();
        }
        catch (Exception exception) {
            this.trace(exception.toString());
            exception.printStackTrace();
        }
        this.cTarget = ConnectionDialogSwing.createConnection(this.fMain, "Target Database");
        if (this.cTarget == null) {
            return;
        }
        try {
            this.dTargetMeta = this.cTarget.getMetaData();
            this.sTargetStatement = this.cTarget.createStatement();
        }
        catch (Exception exception) {
            this.trace(exception.toString());
            exception.printStackTrace();
        }
        String[] stringArray2 = new String[]{"TABLE"};
        this.lTableModel.removeAllElements();
        this.tTable = new Vector();
        try {
            Object object;
            this.hTypes = new Hashtable();
            this.trace("Building target type info");
            ResultSet resultSet = this.dTargetMeta.getTypeInfo();
            while (resultSet.next()) {
                this.hTypes.put(new Integer(resultSet.getShort(2)), resultSet.getString(1));
            }
            resultSet.close();
            this.trace("Reading source tables");
            resultSet = this.dSourceMeta.getTables(null, null, null, stringArray2);
            int n = 0;
            while (resultSet.next()) {
                Table table = new Table();
                table.iTableIndex = n++;
                object = resultSet.getString(3);
                table.bTransfer = true;
                table.sSourceTable = object;
                table.sDestTable = object;
                table.sDestDrop = "DROP TABLE " + (String)object;
                table.sSourceSelect = "SELECT * FROM " + (String)object;
                table.sDestDelete = "DELETE FROM " + (String)object;
                table.bCreate = true;
                table.bDelete = true;
                table.bDrop = true;
                table.bInsert = true;
                this.tTable.addElement(table);
                this.lTableModel.addElement(object);
            }
            resultSet.close();
            int n2 = 0;
            while (n2 < this.tTable.size()) {
                object = (Table)this.tTable.elementAt(n2);
                this.trace("Reading source columns for table " + ((Table)object).sSourceTable);
                ResultSet resultSet2 = this.dSourceMeta.getColumns(null, null, ((Table)object).sSourceTable, null);
                String string = "CREATE TABLE " + ((Table)object).sSourceTable + "(";
                String string2 = "INSERT INTO " + ((Table)object).sSourceTable + " VALUES(";
                Vector<Integer> vector = new Vector<Integer>();
                while (resultSet2.next()) {
                    String string3 = resultSet2.getString(4);
                    int n3 = resultSet2.getShort(5);
                    String string4 = resultSet2.getString(6);
                    if (n3 == 11 && string4.toUpperCase().equals("DATETIME")) {
                        this.trace("Converted DATETIME (type 11) to TIMESTAMP");
                        n3 = 93;
                    } else if (n3 == -9 && string4.toUpperCase().equals("NVARCHAR")) {
                        this.trace("Converted NVARCHAR (type -9) to VARCHAR");
                        n3 = 12;
                    } else if (n3 == -8 && string4.toUpperCase().equals("NCHAR")) {
                        this.trace("Converted NCHAR (type -8) to VARCHAR");
                        n3 = 12;
                    } else if (n3 == -10 && string4.toUpperCase().equals("NTEXT")) {
                        this.trace("Converted NTEXT (type -10) to VARCHAR");
                        n3 = 12;
                    }
                    Integer n4 = new Integer(n3);
                    String string5 = (String)this.hTypes.get(n4);
                    if (string5 == null) {
                        string5 = string4;
                        this.trace("No mapping for type: " + n4 + " source type is " + string5);
                    }
                    vector.addElement(n4);
                    string = string + string3 + " " + string5 + ",";
                    string2 = string2 + "?,";
                }
                resultSet2.close();
                string = string.substring(0, string.length() - 1) + ")";
                string2 = string2.substring(0, string2.length() - 1) + ")";
                ((Table)object).sDestCreate = string;
                ((Table)object).sDestInsert = string2;
                ((Table)object).iColumnType = new int[vector.size()];
                int n5 = 0;
                while (n5 < vector.size()) {
                    ((Table)object).iColumnType[n5] = (Integer)vector.elementAt(n5);
                    ++n5;
                }
                ++n2;
            }
            this.trace("Edit definitions and press [Start Transfer]");
        }
        catch (SQLException sQLException) {
            this.trace("SQL Exception reading Metadata: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        this.fMain.show();
    }

    void addMenuItems(JMenu jMenu, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateEnabled(true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getLastIndex();
        int n2 = listSelectionEvent.getFirstIndex();
        block0: while (n2 <= listSelectionEvent.getLastIndex()) {
            if (this.lTable.isSelectedIndex(n2)) {
                String string = (String)this.lTableModel.getElementAt(n2);
                int n3 = 0;
                while (n3 < this.tTable.size()) {
                    Table table = (Table)this.tTable.elementAt(n3);
                    if (table != null && table.sSourceTable.equals(string)) {
                        this.saveTable();
                        this.displayTable(table);
                        this.updateEnabled(true);
                        break block0;
                    }
                    ++n3;
                }
                break;
            }
            ++n2;
        }
    }

    void saveTable() {
        if (this.tCurrent == null) {
            return;
        }
        Table table = this.tCurrent;
        table.sSourceTable = this.tSourceTable.getText();
        table.sDestTable = this.tDestTable.getText();
        table.sDestDrop = this.tDestDrop.getText();
        table.sDestCreate = this.tDestCreate.getText();
        table.sDestDelete = this.tDestDelete.getText();
        table.sSourceSelect = this.tSourceSelect.getText();
        table.sDestInsert = this.tDestInsert.getText();
        table.bTransfer = this.cTransfer.isSelected();
        table.bDrop = this.cDrop.isSelected();
        table.bCreate = this.cCreate.isSelected();
        table.bDelete = this.cDelete.isSelected();
        table.bInsert = this.cInsert.isSelected();
    }

    void displayTable(Table table) {
        this.tCurrent = table;
        if (table == null) {
            return;
        }
        this.tSourceTable.setText(table.sSourceTable);
        this.tDestTable.setText(table.sDestTable);
        this.tDestDrop.setText(table.sDestDrop);
        this.tDestCreate.setText(table.sDestCreate);
        this.tDestDelete.setText(table.sDestDelete);
        this.tSourceSelect.setText(table.sSourceSelect);
        this.tDestInsert.setText(table.sDestInsert);
        this.cTransfer.setSelected(table.bTransfer);
        this.cDrop.setSelected(table.bDrop);
        this.cCreate.setSelected(table.bCreate);
        this.cDelete.setSelected(table.bDelete);
        this.cInsert.setSelected(table.bInsert);
    }

    void updateEnabled(boolean bl) {
        boolean bl2 = this.cTransfer.isSelected();
        this.tDestTable.setEnabled(bl && bl2);
        this.tDestDrop.setEnabled(bl && bl2 && this.cDrop.isSelected());
        this.tDestCreate.setEnabled(bl && bl2 && this.cCreate.isSelected());
        this.tDestDelete.setEnabled(bl && bl2 && this.cDelete.isSelected());
        this.tSourceSelect.setEnabled(bl && bl2);
        this.tDestInsert.setEnabled(bl && bl2 && this.cInsert.isSelected());
        this.cDrop.setEnabled(bl && bl2);
        this.cCreate.setEnabled(bl && bl2);
        this.cDelete.setEnabled(bl && bl2);
        this.cInsert.setEnabled(bl && bl2);
        this.bStart.setEnabled(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanExit() {
        try {
            try {
                this.cSource.close();
                this.cTarget.close();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException.getMessage());
                sQLException.printStackTrace(System.err);
                Object var3_2 = null;
                this.fMain.dispose();
                if (!bMustExit) return;
                System.exit(0);
                return;
            }
            Object var3_1 = null;
            this.fMain.dispose();
            if (!bMustExit) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fMain.dispose();
            if (!bMustExit) throw throwable;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof JMenuItem) {
            string = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string.equals("Start Transfer")) {
            this.transfer();
        } else if (string.equals("Insert 10 rows only")) {
            this.iMaxRows = 10;
        } else if (string.equals("Insert 1000 rows only")) {
            this.iMaxRows = 1000;
        } else if (string.equals("Insert all rows")) {
            this.iMaxRows = 0;
        } else if (string.equals("Close")) {
            this.cleanExit();
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            if (this.cSource != null) {
                this.cSource.close();
            }
            if (this.cTarget != null) {
                this.cTarget.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanExit();
    }

    void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(SystemColor.control);
        jPanel.setLayout(new GridLayout(16, 1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tSourceTable = new JTextField();
        this.tSourceTable.setEnabled(false);
        this.tDestTable = new JTextField();
        this.tDestDrop = new JTextField();
        this.tDestCreate = new JTextField();
        this.tDestDelete = new JTextField();
        this.tSourceSelect = new JTextField();
        this.tDestInsert = new JTextField();
        this.cTransfer = new JCheckBox("Transfer to destination table", true);
        this.cTransfer.addItemListener(this);
        this.cDrop = new JCheckBox("Drop destination table (ignore error)", true);
        this.cDrop.addItemListener(this);
        this.cCreate = new JCheckBox("Create destination table", true);
        this.cCreate.addItemListener(this);
        this.cDelete = new JCheckBox("Delete rows in destination table", true);
        this.cDelete.addItemListener(this);
        this.cInsert = new JCheckBox("Insert into destination", true);
        this.cInsert.addItemListener(this);
        jPanel.add(this.createLabel("Source table"));
        jPanel.add(this.tSourceTable);
        jPanel.add(this.cTransfer);
        jPanel.add(this.tDestTable);
        jPanel.add(this.cDrop);
        jPanel.add(this.tDestDrop);
        jPanel.add(this.cCreate);
        jPanel.add(this.tDestCreate);
        jPanel.add(this.cDelete);
        jPanel.add(this.tDestDelete);
        jPanel.add(this.createLabel("Select source records"));
        jPanel.add(this.tSourceSelect);
        jPanel.add(this.cInsert);
        jPanel.add(this.tDestInsert);
        jPanel.add(this.createLabel(""));
        this.bStart = new JButton("Start Transfer");
        this.bStart.addActionListener(this);
        jPanel.add(this.bStart);
        this.fMain.getContentPane().add((Component)this.createBorderPanel(jPanel), "Center");
        this.lTableModel = new DefaultListModel();
        this.lTable = new JList(this.lTableModel);
        this.lTable.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.lTable);
        this.fMain.getContentPane().add((Component)jScrollPane, "West");
        this.tMessage = new JTextField();
        JPanel jPanel2 = this.createBorderPanel(this.tMessage);
        this.fMain.getContentPane().add((Component)jPanel2, "South");
    }

    JPanel createBorderPanel(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(SystemColor.control);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "Center");
        return jPanel;
    }

    JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBackground(SystemColor.control);
        return jLabel;
    }

    void trace(String string) {
        this.tMessage.setText(string);
        System.out.println(string);
    }

    void transfer() {
        this.saveTable();
        this.updateEnabled(false);
        this.trace("Start Transfer");
        try {
            int n = 0;
            while (n < this.tTable.size()) {
                Table table = (Table)this.tTable.elementAt(n);
                if (table.sSourceTable.equals(this.tSourceTable.getText())) {
                    this.transfer(table);
                    break;
                }
                ++n;
            }
            this.trace("Transfer finished successfully");
        }
        catch (SQLException sQLException) {
            String string = this.tMessage.getText();
            this.trace("Transfer stopped - " + string + " / " + this.sLast + " / Error: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            String string = this.tMessage.getText();
            this.trace("Transfer stopped - " + string + " / " + this.sLast + " / Error: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.updateEnabled(true);
    }

    void transfer(Table table) throws SQLException {
        this.lTable.setSelectedIndex(table.iTableIndex);
        this.displayTable(table);
        if (!table.bTransfer) {
            this.trace("Table " + table.sSourceSelect + " not transfered");
            return;
        }
        this.trace("Table " + table.sSourceSelect + ": start transfer");
        if (table.bDelete) {
            try {
                this.trace("Executing " + table.sDestDrop);
                this.sTargetStatement.execute(table.sDestDrop);
            }
            catch (SQLException sQLException) {
                this.trace("Ignoring error " + sQLException.getMessage());
            }
        }
        if (table.bCreate) {
            this.trace("Executing " + table.sDestCreate);
            this.sTargetStatement.execute(table.sDestCreate);
        }
        if (table.bDelete) {
            this.trace("Executing " + table.sDestDelete);
            this.sTargetStatement.execute(table.sDestDelete);
        }
        if (table.bInsert) {
            this.trace("Executing " + table.sDestInsert);
            PreparedStatement preparedStatement = this.cTarget.prepareStatement(table.sDestInsert);
            this.trace("Executing " + table.sSourceSelect);
            ResultSet resultSet = this.sSourceStatement.executeQuery(table.sSourceSelect);
            int n = 0;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int[] nArray = new int[resultSetMetaData.getColumnCount()];
            int n2 = 0;
            while (n2 < resultSetMetaData.getColumnCount()) {
                nArray[n2] = resultSetMetaData.getColumnType(n2 + 1);
                ++n2;
            }
            this.trace("Start transfering data...");
            while (resultSet.next()) {
                this.transferRow(nArray, resultSet, preparedStatement);
                if (this.iMaxRows != 0 && n == this.iMaxRows) break;
                ++n;
                if (this.iMaxRows == 0 && ++n % 100 != 0) continue;
                this.trace("Transfered " + n + " rows");
            }
            this.trace("Finished");
        }
    }

    void transferRow(int[] nArray, ResultSet resultSet, PreparedStatement preparedStatement) throws SQLException {
        this.sLast = null;
        preparedStatement.clearParameters();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.sLast = "column=" + (n2 + 1) + " datatype=" + n3;
            Object object = resultSet.getObject(n2 + 1);
            if (n3 == 5 && object instanceof Integer) {
                this.sLast = this.sLast + " SMALLINT: Converted Integer to Short";
                object = new Short((short)((Integer)object).intValue());
            } else if (n3 == -6 && object instanceof Integer) {
                this.sLast = this.sLast + " TINYINT: Converted Integer to Byte";
                object = new Byte((byte)((Integer)object).intValue());
            }
            this.sLast = this.sLast + " value=" + object;
            preparedStatement.setObject(n2 + 1, object, nArray[n2]);
            ++n2;
        }
        preparedStatement.execute();
        this.sLast = null;
    }

    class Table {
        int iTableIndex;
        String sSourceTable;
        String sDestTable;
        String sDestDrop;
        String sDestCreate;
        String sDestDelete;
        String sSourceSelect;
        String sDestInsert;
        boolean bTransfer;
        boolean bDrop;
        boolean bCreate;
        boolean bDelete;
        boolean bInsert;
        int[] iColumnType;

        Table() {
        }
    }
}

