/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Expression;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class TableFilter {
    private Table tTable;
    private String sAlias;
    private Index iIndex;
    private Node nCurrent;
    private Object[] oEmptyData;
    private Expression eStart;
    private Expression eEnd;
    private Expression eAnd;
    private boolean bOuterJoin;
    Object[] oCurrentData;

    TableFilter(Table table, String string, boolean bl) {
        this.tTable = table;
        this.iIndex = null;
        this.sAlias = string != null ? string : table.getName();
        this.bOuterJoin = bl;
        this.oEmptyData = this.tTable.getNewRow();
    }

    String getName() {
        return this.sAlias;
    }

    Table getTable() {
        return this.tTable;
    }

    void setCondition(Expression expression) throws SQLException {
        Index index;
        int n;
        int n2 = expression.getType();
        Expression expression2 = expression.getArg();
        Expression expression3 = expression.getArg2();
        if (n2 == 28) {
            this.setCondition(expression2);
            this.setCondition(expression3);
            return;
        }
        switch (n2) {
            case 26: 
            case 27: 
            case 30: {
                n = 0;
                break;
            }
            case 21: {
                n = 1;
                break;
            }
            case 22: 
            case 23: {
                n = 2;
                break;
            }
            case 24: 
            case 25: {
                n = 3;
                break;
            }
            default: {
                return;
            }
        }
        if (expression2.getFilter() != this) {
            if (expression3.getFilter() == this && n != 0) {
                expression.swapCondition();
                this.setCondition(expression);
                return;
            }
            return;
        }
        Trace.doAssert(expression2.getFilter() == this, "setCondition");
        if (!expression3.isResolved()) {
            return;
        }
        if (n == 0) {
            this.addAndCondition(expression);
            return;
        }
        int n3 = expression2.getColumnNr();
        Index index2 = this.tTable.getIndexForColumn(n3);
        if (index2 == null || this.iIndex != index2 && this.iIndex != null) {
            this.addAndCondition(expression);
            return;
        }
        if (this.tTable.isText() && index2 != (index = this.tTable.getPrimaryIndex())) {
            Node node = index.getRoot();
            while (node != null) {
                node = node.getRight();
            }
        }
        this.iIndex = index2;
        if (n == 1) {
            if (this.eStart != null || this.eEnd != null) {
                this.addAndCondition(expression);
                return;
            }
            this.eEnd = this.eStart = new Expression(expression);
        } else if (n == 2) {
            if (this.eStart != null) {
                this.addAndCondition(expression);
                return;
            }
            this.eStart = new Expression(expression);
        } else if (n == 3) {
            if (this.eEnd != null) {
                this.addAndCondition(expression);
                return;
            }
            this.eEnd = new Expression(expression);
        }
        expression.setTrue();
    }

    boolean findFirst() throws SQLException {
        if (this.iIndex == null) {
            this.iIndex = this.tTable.getPrimaryIndex();
        }
        if (this.eStart == null) {
            this.nCurrent = this.iIndex.first();
        } else {
            int n = this.eStart.getArg().getDataType();
            Object object = this.eStart.getArg2().getValue(n);
            this.nCurrent = this.iIndex.findFirst(object, this.eStart.getType());
        }
        while (this.nCurrent != null) {
            this.oCurrentData = this.nCurrent.getData();
            if (!this.test(this.eEnd)) break;
            if (this.test(this.eAnd)) {
                return true;
            }
            this.nCurrent = this.iIndex.next(this.nCurrent);
        }
        this.oCurrentData = this.oEmptyData;
        return this.bOuterJoin;
    }

    boolean next() throws SQLException {
        if (this.bOuterJoin && this.nCurrent == null) {
            return false;
        }
        this.nCurrent = this.iIndex.next(this.nCurrent);
        while (this.nCurrent != null) {
            this.oCurrentData = this.nCurrent.getData();
            if (!this.test(this.eEnd)) break;
            if (this.test(this.eAnd)) {
                return true;
            }
            this.nCurrent = this.iIndex.next(this.nCurrent);
        }
        this.oCurrentData = this.oEmptyData;
        return false;
    }

    private void addAndCondition(Expression expression) {
        Expression expression2;
        Expression expression3 = new Expression(expression);
        this.eAnd = this.eAnd == null ? expression3 : (expression2 = new Expression(28, this.eAnd, expression3));
        expression.setTrue();
    }

    private boolean test(Expression expression) throws SQLException {
        if (expression == null) {
            return true;
        }
        return expression.test();
    }
}

