/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Vector;
import org.hsqldb.Cache;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Index;
import org.hsqldb.Log;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;

class Table {
    static final int MEMORY_TABLE = 0;
    static final int CACHED_TABLE = 1;
    static final int TEXT_TABLE = 2;
    private String tableName;
    private String statementName;
    private boolean isNameQuoted;
    private Vector vColumn;
    private Vector vIndex;
    private int iVisibleColumns;
    private int iColumnCount;
    private int[] iPrimaryKey;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    private Vector vConstraint;
    private int iConstraintCount;
    Vector[] vTrigs;
    private int[] colTypes;
    protected Database dDatabase;
    protected Cache cCache;
    protected Log lLog;
    protected boolean isCached;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isText;

    Table(Database database, boolean bl, String string, boolean bl2, boolean bl3) throws SQLException {
        this.dDatabase = database;
        this.isTemp = bl;
        this.lLog = database.getLog();
        if (bl3 && this.lLog != null) {
            this.cCache = this.lLog.getCache();
            this.isCached = true;
        }
        this.tableName = this.statementName = string;
        this.isNameQuoted = bl2;
        if (this.isNameQuoted) {
            this.statementName = StringConverter.toQuotedString(this.tableName, '\"', true);
        }
        this.iPrimaryKey = null;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.vConstraint = new Vector();
        this.vTrigs = new Vector[TriggerDef.numTrigs()];
        int n = 0;
        while (n < TriggerDef.numTrigs()) {
            this.vTrigs[n] = new Vector();
            ++n;
        }
    }

    void addConstraint(Constraint constraint) {
        this.vConstraint.addElement(constraint);
        ++this.iConstraintCount;
    }

    Vector getConstraints() {
        return this.vConstraint;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = n;
        while (n3 < this.iConstraintCount) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n3);
            if (constraint.getType() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void addColumn(String string, int n) throws SQLException {
        this.addColumn(string, false, n, 0, 0, true, false, null);
    }

    void addColumn(Column column) throws SQLException {
        this.addColumn(column.colName, column.isNameQuoted, column.getType(), column.getSize(), column.getScale(), column.isNullable(), column.isIdentity(), null);
    }

    void addColumn(String string, boolean bl, int n, int n2, int n3, boolean bl2, boolean bl3, String string2) throws SQLException {
        if (this.searchColumn(string) >= 0) {
            throw Trace.error(27);
        }
        if (bl3) {
            Trace.check(n == 4, 16, string);
            Trace.check(this.iIdentityColumn == -1, 24, string);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.doAssert(this.iPrimaryKey == null, "Table.addColumn");
        this.vColumn.addElement(new Column(string, bl, bl2, n, n2, n3, bl3, string2));
        ++this.iColumnCount;
    }

    void addColumns(Result result) throws SQLException {
        int n = 0;
        while (n < result.getColumnCount()) {
            this.addColumn(result.sLabel[n], false, result.colType[n], result.colSize[n], result.colScale[n], true, false, null);
            ++n;
        }
    }

    String getName() {
        return this.tableName;
    }

    boolean isNameQuoted() {
        return this.isNameQuoted;
    }

    protected String getExtendedName() {
        return this.statementName;
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    protected Table duplicate() throws SQLException {
        return new Table(this.dDatabase, this.isTemp, this.tableName, this.isNameQuoted, this.isCached);
    }

    private Table moveDefinition(String string) throws SQLException {
        Table table = this.duplicate();
        int n = 0;
        while (n < this.getInternalColumnCount()) {
            table.addColumn(this.getColumn(n));
            ++n;
        }
        table.createPrimaryKey(this.iPrimaryKey);
        table.iVisibleColumns = this.iVisibleColumns;
        Index index = null;
        while ((index = this.getNextIndex(index)) != null) {
            if (string != null && index.getName().equals(string) || index == this.getPrimaryIndex()) continue;
            table.createIndex(index);
        }
        int n2 = 0;
        while (n2 < this.iConstraintCount) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n2);
            constraint.replaceTable(this, table);
            ++n2;
        }
        table.vConstraint = this.vConstraint;
        return table;
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    int getColumnNr(String string) throws SQLException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equals(((Column)this.vColumn.elementAt((int)n)).colName)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Index getPrimaryIndex() throws SQLException {
        if (this.iPrimaryKey == null) {
            return null;
        }
        return this.getIndex(0);
    }

    Index getIndexForColumn(int n) throws SQLException {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Index index = this.getIndex(n2);
            if (index.getColumns()[0] == n) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    Index getIndexForColumns(int[] nArray) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n2 >= nArray2.length || nArray2[n2] != nArray[n2]) break;
                ++n2;
            }
            if (n2 == nArray.length) {
                return index;
            }
            ++n;
        }
        return null;
    }

    String getIndexRoots() throws SQLException {
        Trace.doAssert(this.isCached, "Table.getIndexRootData");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.iIndexCount) {
            Node node = this.getIndex(n).getRoot();
            if (node != null) {
                stringBuffer.append(node.getKey());
                stringBuffer.append(' ');
            } else {
                stringBuffer.append("-1 ");
            }
            ++n;
        }
        stringBuffer.append(this.iIdentityId);
        return stringBuffer.toString();
    }

    void setIndexRoots(String string) throws SQLException {
        Trace.check(this.isCached, 22);
        int n = 0;
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            int n3 = string.indexOf(32, n);
            int n4 = Integer.parseInt(string.substring(n, n3));
            if (n4 != -1) {
                Row row = this.cCache.getRow(n4, this);
                Node node = null;
                if (row != null) {
                    node = row.getNode(n2);
                }
                this.getIndex(n2).setRoot(node);
            }
            n = n3 + 1;
            ++n2;
        }
        this.iIdentityId = Integer.parseInt(string.substring(n));
    }

    Index getNextIndex(Index index) {
        int n = 0;
        if (index != null) {
            while (n < this.iIndexCount && this.getIndex(n) != index) {
                ++n;
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    void createForeignKey(int[] nArray, int[] nArray2, String string, Table table, boolean bl) throws SQLException {
        Index index = table.getIndexForColumns(nArray2);
        boolean bl2 = this.dDatabase.getProperties().isPropertyTrue("sql.strict_fk");
        if (table.isTemp() != this.isTemp()) {
            throw Trace.error(47, "both tables must be TEMP tables");
        }
        if (bl2 && (index == null || !index.isUnique())) {
            throw Trace.error(26, "needs unique index on column in " + table.getStatementName() + " for foreign key");
        }
        Index index2 = this.getIndexForColumns(nArray);
        if (index2 == null) {
            String string2 = string;
            if (!string2.startsWith("SYSTEM_FK_")) {
                string2 = "SYSTEM_FK_" + string2;
            }
            index2 = this.createIndex(nArray, string2, false);
        }
        boolean bl3 = this.dDatabase.getProperties().isPropertyTrue("sql.strong_fk");
        String string3 = string;
        if (string3.startsWith("SYSTEM_FK_")) {
            string3 = string3.substring("SYSTEM_FK_".length());
        }
        if (index == null || bl3 && !index.isUnique()) {
            index = table.createIndex(nArray2, "SYSTEM_REF_" + string3, bl3);
        }
        this.addConstraint(new Constraint(string, 0, table, this, nArray2, nArray, index, index2, bl));
        table.addConstraint(new Constraint(string3, 1, table, this, nArray2, nArray, index, index2, bl));
    }

    void createPrimaryKey() throws SQLException {
        this.createPrimaryKey(null);
    }

    void createPrimaryKey(int[] nArray) throws SQLException {
        Trace.doAssert(this.iPrimaryKey == null, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        if (nArray == null) {
            nArray = new int[]{this.iColumnCount};
            this.addColumn("SYSTEM_ID", false, 4, 0, 0, true, true, null);
        }
        this.iPrimaryKey = nArray;
        this.createIndex(nArray, "SYSTEM_PK", true);
        this.colTypes = new int[this.iColumnCount];
        int n = 0;
        while (n < this.iColumnCount) {
            this.colTypes[n] = this.getColumn(n).getType();
            ++n;
        }
    }

    void createUniqueConstraint(int[] nArray, String string) throws SQLException {
        Constraint constraint = new Constraint(string, 2, this, nArray);
        if (!string.startsWith("SYSTEM_CT_")) {
            string = "SYSTEM_CT_" + string;
        }
        this.createIndex(nArray, string, true);
        this.addConstraint(constraint);
    }

    void createIndex(Index index) throws SQLException {
        this.createIndex(index.getColumns(), index.getName(), index.isUnique());
    }

    Index createIndex(int[] nArray, String string, boolean bl) throws SQLException {
        if (this.isEmpty()) {
            return this.createIndexPrivate(nArray, string, bl);
        }
        Table table = this.moveDefinition(null);
        Index index = table.createIndexPrivate(nArray, string, bl);
        table.moveData(this);
        int n = this.dDatabase.getTableIndex(this);
        this.dDatabase.getTables().setElementAt(table, n);
        return index;
    }

    private Index createIndexPrivate(int[] nArray, String string, boolean bl) throws SQLException {
        Trace.doAssert(this.iPrimaryKey != null, "createIndex");
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName())) {
                throw Trace.error(23);
            }
            ++n;
        }
        int n2 = nArray.length;
        int n3 = this.iPrimaryKey.length;
        int[] nArray2 = new int[bl ? n2 : n2 + n3];
        int[] nArray3 = new int[bl ? n2 : n2 + n3];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = nArray[n4];
            nArray3[n4] = this.getColumn(nArray2[n4]).getType();
            ++n4;
        }
        if (!bl) {
            int n5 = 0;
            while (n5 < n3) {
                nArray2[n2 + n5] = this.iPrimaryKey[n5];
                nArray3[n2 + n5] = this.getColumn(this.iPrimaryKey[n5]).getType();
                ++n5;
            }
        }
        Index index = new Index(string, nArray2, nArray3, bl, n2);
        Trace.doAssert(this.isEmpty(), "createIndex");
        this.vIndex.addElement(index);
        ++this.iIndexCount;
        return index;
    }

    void checkDropIndex(String string) throws SQLException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = 0;
        while (n < this.iConstraintCount) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
            if (constraint.isIndexFK(index)) {
                throw Trace.error(50, string);
            }
            ++n;
        }
    }

    void dropIndex(String string) throws SQLException {
        Table table = this.moveDefinition(string);
        table.moveData(this);
        int n = this.dDatabase.getTableIndex(this);
        this.dDatabase.getTables().setElementAt(table, n);
    }

    boolean isEmpty() {
        if (this.iIndexCount == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    private void moveData(Table table) throws SQLException {
        Object[] objectArray;
        Index index = table.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            objectArray = node.getData();
            this.insertNoCheck(objectArray, null, true);
            node = index.next(node);
        }
        index = this.getPrimaryIndex();
        node = index.first();
        while (node != null) {
            objectArray = node.getData();
            table.deleteNoCheck(objectArray, null, true);
            node = index.next(node);
        }
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        Trace.check(!this.isDataReadOnly(), 32);
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
                constraint.checkUpdate(nArray, result, result2);
                ++n;
            }
        }
    }

    void insert(Result result, Channel channel) throws SQLException {
        Record record = result.rRoot;
        int n = result.getColumnCount();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = record.data[n2];
                ++n2;
            }
            this.insert(objectArray, channel);
            record = record.next;
        }
    }

    void insert(Object[] objectArray, Channel channel) throws SQLException {
        Trace.check(!this.isDataReadOnly(), 32);
        this.fireAll(3, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                ((Constraint)this.vConstraint.elementAt(n)).checkInsert(objectArray);
                ++n;
            }
        }
        this.insertNoCheck(objectArray, channel, true);
        this.fireAll(0, objectArray);
    }

    /*
     * Unable to fully structure code
     */
    void insertNoCheck(Object[] var1_1, Channel var2_2, boolean var3_3) throws SQLException {
        block15: {
            var4_4 = this.iIdentityId;
            if (this.iIdentityColumn != -1) {
                var5_5 = (Integer)var1_1[this.iIdentityColumn];
                if (var5_5 == null) {
                    if (var2_2 != null) {
                        var2_2.setLastIdentity(this.iIdentityId);
                    }
                    var1_1[this.iIdentityColumn] = new Integer(this.iIdentityId++);
                } else {
                    var6_7 = var5_5;
                    if (this.iIdentityId <= var6_7) {
                        if (var2_2 != null) {
                            var2_2.setLastIdentity(var6_7);
                        }
                        this.iIdentityId = var6_7 + 1;
                    }
                }
            }
            var5_6 = 0;
            while (var5_6 < this.iColumnCount) {
                if (var1_1[var5_6] == null && !this.getColumn(var5_6).isNullable()) {
                    this.iIdentityId = var4_4;
                    throw Trace.error(10);
                }
                ++var5_6;
            }
            var6_7 = 0;
            try {
                var7_8 = new Row(this, var1_1);
                if (this.isText) {
                    this.iIdentityId = var7_8.iPos + var7_8.iSize;
                }
                while (var6_7 < this.iIndexCount) {
                    var8_10 = var7_8.getNode(var6_7);
                    this.getIndex(var6_7).insert(var8_10);
                    ++var6_7;
                }
                break block15;
            }
            catch (SQLException var7_9) {
                this.iIdentityId = var4_4;
                --var6_7;
                ** while (var6_7 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                this.getIndex(var6_7).delete(var1_1, var6_7 == 0);
                --var6_7;
                continue;
            }
lbl39:
            // 1 sources

            throw var7_9;
        }
        if (var2_2 != null) {
            var2_2.addTransactionInsert(this, var1_1);
        }
        if (this.lLog != null && !this.isTemp && !this.isReadOnly) {
            this.lLog.write(var2_2, this.getInsertStatement(var1_1));
        }
    }

    void fireAll(int n, Object[] objectArray) {
        if (!this.dDatabase.isReferentialIntegrity()) {
            return;
        }
        Vector vector = this.vTrigs[n];
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            TriggerDef triggerDef = (TriggerDef)vector.elementAt(n3);
            triggerDef.push(objectArray);
            ++n3;
        }
    }

    void fireAll(int n) {
        Object[] objectArray = new Object[]{new String("Statement-level")};
        this.fireAll(n, objectArray);
    }

    void addTrigger(TriggerDef triggerDef) {
        if (Trace.TRACE) {
            Trace.trace("Trigger added " + String.valueOf(triggerDef.vectorIndx));
        }
        this.vTrigs[triggerDef.vectorIndx].addElement(triggerDef);
    }

    void checkCascadeDelete(Object[] objectArray, Channel channel, boolean bl) throws SQLException {
        int n = 0;
        while (n < this.iConstraintCount) {
            Node node;
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
            if (constraint.getType() == 1 && constraint.getRef() != null && (node = constraint.findFkRef(objectArray)) != null) {
                boolean bl2;
                Table table = node.getRow().getTable();
                boolean bl3 = bl2 = table.getNextConstraintIndex(0, 1) != -1;
                if (!bl && !bl2) {
                    return;
                }
                Index index = constraint.getRefIndex();
                int n2 = constraint.getRefColumns()[0];
                Object object = node.getData()[n2];
                Node node2 = node;
                while (node2 != null && object.equals(node2.getData()[n2])) {
                    Node node3 = index.next(node2);
                    if (bl2) {
                        table.checkCascadeDelete(node2.getData(), channel, bl);
                    }
                    if (bl) {
                        table.deleteNoRefCheck(node2.getData(), channel);
                        if (table == this) {
                            node3 = constraint.findFkRef(objectArray);
                        }
                    }
                    node2 = node3;
                }
            }
            ++n;
        }
    }

    void delete(Object[] objectArray, Channel channel) throws SQLException {
        this.fireAll(10, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            this.checkCascadeDelete(objectArray, channel, false);
            this.checkCascadeDelete(objectArray, channel, true);
        }
        this.deleteNoCheck(objectArray, channel, true);
        this.fireAll(7, objectArray);
    }

    private void deleteNoRefCheck(Object[] objectArray, Channel channel) throws SQLException {
        this.fireAll(10, objectArray);
        this.deleteNoCheck(objectArray, channel, true);
        this.fireAll(7, objectArray);
    }

    void deleteNoCheck(Object[] objectArray, Channel channel, boolean bl) throws SQLException {
        int n = 1;
        while (n < this.iIndexCount) {
            this.getIndex(n).delete(objectArray, false);
            ++n;
        }
        this.getIndex(0).delete(objectArray, true);
        if (channel != null) {
            channel.addTransactionDelete(this, objectArray);
        }
        if (this.lLog != null && !this.isTemp && !this.isReadOnly) {
            this.lLog.write(channel, this.getDeleteStatement(objectArray));
        }
    }

    protected String getStatementName() {
        return this.statementName;
    }

    String getInsertStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.getExtendedName());
        stringBuffer.append(" VALUES(");
        int n = 0;
        while (n < this.iVisibleColumns) {
            stringBuffer.append(Column.createSQLString(objectArray[n], this.getColumn(n).getType()));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.elementAt(n);
    }

    int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return (Index)this.vIndex.elementAt(n);
    }

    private String getDeleteStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.getExtendedName());
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                Column column = this.getColumn(n);
                stringBuffer.append(column.statementName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createSQLString(objectArray[n], column.getType()));
                if (n < this.iVisibleColumns - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.iPrimaryKey.length) {
                Column column = this.getColumn(this.iPrimaryKey[n]);
                stringBuffer.append(column.statementName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createSQLString(objectArray[n], column.getType()));
                if (n < this.iPrimaryKey.length - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    Node getNode(int n, int n2) throws SQLException {
        Node node = null;
        Row row = this.getRow(n);
        if (row != null) {
            node = row.getNode(n2);
        }
        return node;
    }

    Row getRow(int n) throws SQLException {
        if (this.isCached) {
            return this.cCache.getRow(n, this);
        }
        return null;
    }

    void putRow(Row row) throws SQLException {
        if (this.cCache != null) {
            this.cCache.add(row);
        }
    }

    void removeRow(Row row) throws SQLException {
        if (this.cCache != null) {
            this.cCache.free(row, row.iPos, row.iSize);
        }
    }

    void cleanUp() throws SQLException {
        if (this.cCache != null) {
            this.cCache.cleanUp();
        }
    }

    Node indexRow(Row row) throws SQLException {
        return null;
    }

    boolean equals(String string, Channel channel) throws SQLException {
        return this.tableName.equals(string);
    }

    final boolean isText() {
        return this.isText;
    }

    final boolean isTemp() {
        return this.isTemp;
    }

    final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void setDataReadOnly(boolean bl) throws SQLException {
        this.isReadOnly = bl;
    }
}

