/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.HsqlServerProperties;
import org.hsqldb.ServerConnection;
import org.hsqldb.jdbcSystem;

public class Server {
    Database mDatabase;
    HsqlServerProperties serverProperties;
    private boolean traceMessages;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && (object = stringArray[0]) != null && ((String)object).startsWith("-?")) {
            Server.printHelp();
            return;
        }
        object = new Server();
        HsqlProperties hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        ((Server)object).setProperties(hsqlProperties);
        super.run();
    }

    void setProperties(HsqlProperties hsqlProperties) {
        this.serverProperties = new HsqlServerProperties("server.properties");
        this.serverProperties.addProperties(hsqlProperties);
        this.serverProperties.setPropertyIfNotExists("server.database", "test");
        this.serverProperties.setPropertyIfNotExists("server.port", String.valueOf(9001));
        if (this.serverProperties.isPropertyTrue("server.trace")) {
            jdbcSystem.setLogToSystem(true);
        }
        this.traceMessages = !this.serverProperties.isPropertyTrue("server.silent");
    }

    private void run() {
        Object object;
        ServerSocket serverSocket = null;
        try {
            int n = Integer.parseInt(this.serverProperties.getProperty("server.port"));
            object = this.serverProperties.getProperty("server.database");
            System.out.println("Opening database: " + (String)object);
            this.printTraceMessages();
            this.mDatabase = new Database((String)object);
            serverSocket = new ServerSocket(n);
        }
        catch (Exception exception) {
            this.traceError("Server.run/init: " + exception);
            exception.printStackTrace();
            return;
        }
        try {
            while (true) {
                Socket socket = serverSocket.accept();
                object = new ServerConnection(socket, this);
                Thread thread = new Thread((Runnable)object);
                thread.start();
            }
        }
        catch (IOException iOException) {
            this.traceError("Server.run/loop: " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
    }

    static void printHelp() {
        System.out.println("Usage: java Server [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display print JDBC trace messages\nThe command line arguments override the values in the server.properties file.");
        System.exit(0);
    }

    void printTraceMessages() {
        this.trace("server.port    =" + this.serverProperties.getProperty("server.port"));
        this.trace("server.database=" + this.serverProperties.getProperty("server.database"));
        this.trace("server.silent  =" + this.serverProperties.getProperty("server.silent"));
        System.out.println("HSQLDB server 1.7.0 is running");
        System.out.println("Press [Ctrl]+[C] to abort");
    }

    void trace(String string) {
        if (this.traceMessages) {
            System.out.println(string);
        }
    }

    void traceError(String string) {
        System.out.println(string);
    }
}

