/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.BinaryDatabaseRowInput;
import org.hsqldb.BinaryDatabaseRowOutput;
import org.hsqldb.Column;
import org.hsqldb.Record;
import org.hsqldb.Trace;

class Result {
    private Record rTail;
    private int iSize;
    private int iColumnCount;
    static final int UPDATECOUNT = 0;
    static final int ERROR = 1;
    static final int DATA = 2;
    int iMode;
    String sError;
    int errorCode;
    int iUpdateCount;
    Record rRoot;
    String[] sLabel;
    String[] sTable;
    String[] sName;
    boolean[] isNameQuoted;
    int[] colType;
    int[] colSize;
    int[] colScale;

    Result() {
        this.iMode = 0;
        this.iUpdateCount = 0;
    }

    Result(String string, int n) {
        this.iMode = 1;
        this.sError = string;
        this.errorCode = n;
    }

    Result(int n) {
        this.prepareData(n);
        this.iColumnCount = n;
    }

    Result(byte[] byArray) throws SQLException {
        try {
            BinaryDatabaseRowInput binaryDatabaseRowInput = new BinaryDatabaseRowInput(byArray);
            this.iMode = binaryDatabaseRowInput.readInt();
            if (this.iMode == 1) {
                throw Trace.getError(binaryDatabaseRowInput.readInt(), binaryDatabaseRowInput.readString());
            }
            if (this.iMode == 0) {
                this.iUpdateCount = binaryDatabaseRowInput.readInt();
            } else if (this.iMode == 2) {
                int n = binaryDatabaseRowInput.readInt();
                this.prepareData(n);
                this.iColumnCount = n;
                int n2 = 0;
                while (n2 < n) {
                    this.colType[n2] = binaryDatabaseRowInput.readInt();
                    this.sLabel[n2] = binaryDatabaseRowInput.readString();
                    this.sTable[n2] = binaryDatabaseRowInput.readString();
                    this.sName[n2] = binaryDatabaseRowInput.readString();
                    ++n2;
                }
                while (binaryDatabaseRowInput.available() != 0) {
                    this.add(binaryDatabaseRowInput.readData(this.colType));
                }
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
    }

    int getSize() {
        return this.iSize;
    }

    void setColumnCount(int n) {
        this.iColumnCount = n;
    }

    int getColumnCount() {
        return this.iColumnCount;
    }

    void append(Result result) {
        if (this.rRoot == null) {
            this.rRoot = result.rRoot;
        } else {
            this.rTail.next = result.rRoot;
        }
        this.rTail = result.rTail;
        this.iSize += result.iSize;
    }

    void add(Object[] objectArray) {
        Record record = new Record();
        record.data = objectArray;
        if (this.rRoot == null) {
            this.rRoot = record;
        } else {
            this.rTail.next = record;
        }
        this.rTail = record;
        ++this.iSize;
    }

    void trimResult(int n, int n2) {
        Record record = this.rRoot;
        if (record == null) {
            return;
        }
        if (n > this.iSize) {
            this.iSize = 0;
            this.rTail = null;
            this.rRoot = null;
            return;
        }
        this.iSize -= n;
        int n3 = 0;
        while (n3 < n) {
            record = record.next;
            if (record == null) {
                this.iSize = 0;
                this.rRoot = this.rTail = record;
                return;
            }
            ++n3;
        }
        this.rRoot = record;
        if (n2 == 0 || n2 >= this.iSize) {
            return;
        }
        int n4 = 1;
        while (n4 < n2) {
            record = record.next;
            if (record == null) {
                return;
            }
            ++n4;
        }
        record.next = null;
        this.rTail = record;
    }

    void removeDuplicates() throws SQLException {
        Record record;
        if (this.rRoot == null) {
            return;
        }
        int n = this.getColumnCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            nArray2[n2] = 1;
            ++n2;
        }
        this.sortResult(nArray, nArray2);
        Record record2 = this.rRoot;
        while ((record = record2.next) != null) {
            if (this.compareRecord(record2.data, record.data, n) == 0) {
                record2.next = record.next;
                --this.iSize;
                continue;
            }
            record2 = record;
        }
        this.rTail = record2;
        Trace.doAssert(this.rTail.next == null, "rTail not correct in Result.removeDuplicates iSise =" + this.iSize);
    }

    void removeSecond(Result result) throws SQLException {
        this.removeDuplicates();
        result.removeDuplicates();
        int n = this.getColumnCount();
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n2 = 0;
        while (record != null && record3 != null) {
            n2 = this.compareRecord(record.data, record3.data, n);
            if (n2 == 0) {
                if (bl) {
                    this.rRoot = record2 = record.next;
                } else {
                    record2.next = record.next;
                }
                record = record.next;
                --this.iSize;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record2 = record;
            bl = false;
            record = record.next;
        }
        while (record != null) {
            record2 = record;
            record = record.next;
        }
        this.rTail = record2;
        Trace.doAssert(this.rRoot == null && this.rTail == null || this.rTail.next == null, "rTail not correct in Result.removeSecond iSise =" + this.iSize);
    }

    void removeDifferent(Result result) throws SQLException {
        this.removeDuplicates();
        result.removeDuplicates();
        int n = this.getColumnCount();
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n2 = 0;
        this.iSize = 0;
        while (record != null && record3 != null) {
            n2 = this.compareRecord(record.data, record3.data, n);
            if (n2 == 0) {
                if (bl) {
                    this.rRoot = record;
                } else {
                    record2.next = record;
                }
                bl = false;
                record2 = record;
                record = record.next;
                record3 = record3.next;
                ++this.iSize;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record = record.next;
        }
        if (bl) {
            this.rRoot = null;
            record2 = null;
        } else {
            record2.next = null;
        }
        this.rTail = record2;
        Trace.doAssert(this.rRoot == null && this.rTail == null || this.rTail.next == null, "rTail not correct in Result.removeDifference iSise =" + this.iSize);
    }

    void sortResult(int[] nArray, int[] nArray2) throws SQLException {
        if (this.rRoot == null || this.rRoot.next == null) {
            return;
        }
        Record[] recordArray = new Record[2];
        Record[] recordArray2 = new Record[2];
        int n = 0;
        Record record = this.rRoot;
        while (record != null) {
            Record record2 = record.next;
            record.next = recordArray[n];
            recordArray[n] = record;
            record = record2;
            n ^= 1;
        }
        int n2 = 1;
        while (recordArray[1] != null) {
            Record record3 = recordArray[0];
            Record record4 = recordArray[1];
            recordArray2[1] = null;
            recordArray2[0] = null;
            recordArray[1] = null;
            recordArray[0] = null;
            n = 0;
            while (record3 != null) {
                int n3 = n2;
                int n4 = n2;
                while (true) {
                    if (n3 == 0 || record3 == null) {
                        if (n4 == 0 || record4 == null) break;
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else if (n4 == 0 || record4 == null) {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    } else if (this.compareRecord(record3.data, record4.data, nArray, nArray2) > 0) {
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    }
                    if (recordArray[n] == null) {
                        recordArray[n] = record;
                    } else {
                        recordArray2[n].next = record;
                    }
                    recordArray2[n] = record;
                    record.next = null;
                }
                n ^= 1;
            }
            n2 <<= 1;
        }
        this.rRoot = recordArray[0];
        this.rTail = recordArray2[0];
        Trace.doAssert(this.rTail.next == null, "rTail not correct in Result.sortResult iSise =" + this.iSize);
    }

    private int compareRecord(Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2) throws SQLException {
        int n = Column.compare(objectArray[nArray[0]], objectArray2[nArray[0]], this.colType[nArray[0]]);
        if (n == 0) {
            int n2 = 1;
            while (n2 < nArray.length) {
                n = Column.compare(objectArray[nArray[n2]], objectArray2[nArray[n2]], this.colType[nArray[n2]]);
                if (n != 0) {
                    return n * nArray2[n2];
                }
                ++n2;
            }
        }
        return n * nArray2[0];
    }

    private int compareRecord(Object[] objectArray, Object[] objectArray2, int n) throws SQLException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = Column.compare(objectArray[n2], objectArray2[n2], this.colType[n2]);
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    byte[] getBytes() throws SQLException {
        try {
            BinaryDatabaseRowOutput binaryDatabaseRowOutput = new BinaryDatabaseRowOutput();
            binaryDatabaseRowOutput.writeIntData(this.iMode);
            if (this.iMode == 0) {
                binaryDatabaseRowOutput.writeIntData(this.iUpdateCount);
            } else if (this.iMode == 1) {
                binaryDatabaseRowOutput.writeIntData(this.errorCode);
                binaryDatabaseRowOutput.writeString(this.sError);
            } else {
                int n = this.iColumnCount;
                binaryDatabaseRowOutput.writeIntData(n);
                Record record = this.rRoot;
                int n2 = 0;
                while (n2 < n) {
                    binaryDatabaseRowOutput.writeType(this.colType[n2]);
                    binaryDatabaseRowOutput.writeString(this.sLabel[n2]);
                    binaryDatabaseRowOutput.writeString(this.sTable[n2]);
                    binaryDatabaseRowOutput.writeString(this.sName[n2]);
                    ++n2;
                }
                while (record != null) {
                    binaryDatabaseRowOutput.writeData(n, this.colType, record.data);
                    record = record.next;
                }
            }
            return binaryDatabaseRowOutput.toByteArray();
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
    }

    private void prepareData(int n) {
        this.iMode = 2;
        this.sLabel = new String[n];
        this.sTable = new String[n];
        this.sName = new String[n];
        this.isNameQuoted = new boolean[n];
        this.colType = new int[n];
        this.colSize = new int[n];
        this.colScale = new int[n];
    }
}

