/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Row;
import org.hsqldb.Table;

class Node {
    static final int NO_POS = -1;
    int iBalance;
    int iLeft = -1;
    int iRight = -1;
    int iParent = -1;
    Node nLeft;
    Node nRight;
    Node nParent;
    private int iId;
    Node nNext;
    private Row rData;
    private int iData = -1;
    Table tTable;

    Node(Row row, DatabaseRowInputInterface databaseRowInputInterface, int n) throws IOException, SQLException {
        this.iId = n;
        this.tTable = row.getTable();
        this.rData = row;
        this.iData = row.iPos;
        this.iBalance = databaseRowInputInterface.readIntData();
        this.iLeft = databaseRowInputInterface.readIntData();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = databaseRowInputInterface.readIntData();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = databaseRowInputInterface.readIntData();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    Node(Row row, int n) {
        this.iId = n;
        this.tTable = row.getTable();
        if (row.iPos == -1 || !this.tTable.isCached()) {
            this.rData = row;
        } else {
            this.iData = row.iPos;
        }
    }

    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
        this.iParent = 0;
        this.iRight = 0;
        this.iLeft = 0;
        this.tTable = null;
    }

    int getKey() {
        if (this.rData != null) {
            return this.rData.iPos;
        }
        return this.iData;
    }

    void setKey(int n) {
        this.iData = n;
        this.rData = null;
    }

    Row getRow() throws SQLException {
        if (this.rData != null) {
            return this.rData;
        }
        if (this.iData == -1) {
            return null;
        }
        return this.tTable.getRow(this.iData);
    }

    Node getLeft() throws SQLException {
        if (this.nLeft != null) {
            return this.nLeft;
        }
        if (this.iLeft == -1) {
            return null;
        }
        return this.tTable.getNode(this.iLeft, this.iId);
    }

    void setLeft(Node node) throws SQLException {
        if (this.tTable.isIndexCached()) {
            this.getRow().changed();
        }
        this.iLeft = -1;
        this.nLeft = null;
        if (!this.tTable.isIndexCached()) {
            this.nLeft = node;
        } else if (node != null) {
            this.iLeft = node.getKey();
        }
    }

    Node getRight() throws SQLException {
        if (this.nRight != null) {
            return this.nRight;
        }
        if (this.iRight == -1) {
            return null;
        }
        return this.tTable.getNode(this.iRight, this.iId);
    }

    void setRight(Node node) throws SQLException {
        if (this.tTable.isIndexCached()) {
            this.getRow().changed();
        }
        this.iRight = -1;
        this.nRight = null;
        if (!this.tTable.isIndexCached()) {
            this.nRight = node;
        } else if (node != null) {
            this.iRight = node.getKey();
        }
    }

    Node getParent() throws SQLException {
        if (this.nParent != null) {
            return this.nParent;
        }
        if (this.iParent == -1) {
            return null;
        }
        return this.tTable.getNode(this.iParent, this.iId);
    }

    void setParent(Node node) throws SQLException {
        if (this.tTable.isIndexCached()) {
            this.getRow().changed();
        }
        this.iParent = -1;
        this.nParent = null;
        if (!this.tTable.isIndexCached()) {
            this.nParent = node;
        } else if (node != null) {
            this.iParent = node.getKey();
        }
    }

    int getBalance() throws SQLException {
        return this.iBalance;
    }

    void setBalance(int n) throws SQLException {
        if (this.iBalance != n) {
            if (this.tTable.isIndexCached()) {
                this.getRow().changed();
            }
            this.iBalance = n;
        }
    }

    public Object[] getData() throws SQLException {
        return this.getRow().getData();
    }

    boolean equals(Node node) throws SQLException {
        return node == this;
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, SQLException {
        databaseRowOutputInterface.writeIntData(this.iBalance);
        databaseRowOutputInterface.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
        databaseRowOutputInterface.writeIntData(this.iRight == -1 ? 0 : this.iRight);
        databaseRowOutputInterface.writeIntData(this.iParent == -1 ? 0 : this.iParent);
    }
}

