/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.Trace;

public abstract class DatabaseRowInput
extends DataInputStream {
    private boolean makeSystemId = false;

    public DatabaseRowInput(InputStream inputStream) {
        super(inputStream);
    }

    public abstract int getPos() throws IOException;

    public abstract int readIntData() throws IOException;

    abstract int readType(int var1) throws IOException;

    abstract long readLongData() throws IOException;

    abstract String readString() throws IOException;

    abstract String readVarString() throws IOException;

    abstract String readLongVarString() throws IOException;

    abstract String readNumericString() throws IOException;

    abstract ByteArray readByteArray() throws IOException;

    abstract ByteArray readVarByteArray() throws IOException;

    abstract ByteArray readLongVarByteArray() throws IOException;

    public Object[] readData(int[] nArray) throws IOException, SQLException {
        int n = nArray.length;
        Object[] objectArray = new Object[n - (this.makeSystemId ? 1 : 0)];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.readType(n2);
            Object object = null;
            switch (n3) {
                case 0: {
                    object = null;
                    break;
                }
                case 4: {
                    object = new Integer(this.readIntData());
                    break;
                }
                case 6: 
                case 8: {
                    object = new Double(Double.longBitsToDouble(this.readLongData()));
                    break;
                }
                case 12: 
                case 100: {
                    object = this.readVarString();
                    break;
                }
                case 1: {
                    object = this.readString();
                    break;
                }
                case -1: {
                    object = this.readLongVarString();
                    break;
                }
                case 91: {
                    object = Date.valueOf(this.readString());
                    break;
                }
                case 92: {
                    object = Time.valueOf(this.readString());
                    break;
                }
                case 93: {
                    object = Timestamp.valueOf(this.readString());
                    break;
                }
                case 2: 
                case 3: {
                    object = new BigDecimal(this.readNumericString());
                    break;
                }
                case -7: {
                    object = new Boolean(this.readString());
                    break;
                }
                case -6: {
                    object = new Byte(this.readNumericString());
                    break;
                }
                case 5: {
                    object = new Short(this.readNumericString());
                    break;
                }
                case -5: {
                    object = new Long(this.readNumericString());
                    break;
                }
                case 7: {
                    object = new Float(this.readNumericString());
                    break;
                }
                case -2: 
                case 1111: {
                    String string = this.readString();
                    if (string.equals("**")) {
                        object = this.readByteArray();
                        break;
                    }
                    object = new ByteArray(string);
                    break;
                }
                case -3: {
                    String string = this.readVarString();
                    if (string.equals("**")) {
                        object = this.readVarByteArray();
                        break;
                    }
                    object = new ByteArray(string);
                    break;
                }
                case -4: {
                    String string = this.readLongVarString();
                    if (string.equals("**")) {
                        object = this.readLongVarByteArray();
                        break;
                    }
                    object = new ByteArray(string);
                    break;
                }
                default: {
                    throw Trace.error(20, n3);
                }
            }
            objectArray[n2] = object;
            ++n2;
        }
        if (this.makeSystemId) {
            objectArray[n] = new Integer(this.getPos());
        }
        return objectArray;
    }
}

