/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Access;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;

class DatabaseInformation {
    private Database dDatabase;
    private Access aAccess;
    private Vector tTable;
    static final String META_SCHEM = "SCHEM";
    static final String META_CAT = "CAT";
    static final String META_COLUMN_SIZE = "COLUMN_SIZE";
    static final String META_BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String META_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String META_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String META_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    static final String META_ORDINAL_POSITON = "ORDINAL_POSITON";
    static final String META_ASC_OR_DESC = "ASC_OR_DESC";
    private static Hashtable sysTableNames = new Hashtable();
    private static final int SYSTEM_PROCEDURES = 1;
    private static final int SYSTEM_PROCEDURECOLUMNS = 2;
    private static final int SYSTEM_TABLES = 3;
    private static final int SYSTEM_SCHEMAS = 4;
    private static final int SYSTEM_CATALOGS = 5;
    private static final int SYSTEM_TABLETYPES = 6;
    private static final int SYSTEM_COLUMNS = 7;
    private static final int SYSTEM_COLUMNPRIVILEGES = 8;
    private static final int SYSTEM_TABLEPRIVILEGES = 9;
    private static final int SYSTEM_BESTROWIDENTIFIER = 10;
    private static final int SYSTEM_VERSIONCOLUMNS = 11;
    private static final int SYSTEM_PRIMARYKEYS = 12;
    private static final int SYSTEM_IMPORTEDKEYS = 13;
    private static final int SYSTEM_EXPORTEDKEYS = 14;
    private static final int SYSTEM_CROSSREFERENCE = 15;
    private static final int SYSTEM_TYPEINFO = 16;
    private static final int SYSTEM_INDEXINFO = 17;
    private static final int SYSTEM_UDTS = 18;
    private static final int SYSTEM_CONNECTIONINFO = 19;
    private static final int SYSTEM_USERS = 20;

    DatabaseInformation(Database database, Vector vector, Access access) {
        this.dDatabase = database;
        this.tTable = vector;
        this.aAccess = access;
    }

    static boolean isSystemTable(String string) {
        return sysTableNames.get(string) != null;
    }

    Table getSystemTable(String string, Channel channel) throws SQLException {
        Integer n = (Integer)sysTableNames.get(string);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                Table table = this.createTable(string);
                table.addColumn("PROCEDURE_CAT", 12);
                table.addColumn("PROCEDURE_SCHEM", 12);
                table.addColumn("PROCEDURE_NAME", 12);
                table.addColumn("NUM_INPUT_PARAMS", 4);
                table.addColumn("NUM_OUTPUT_PARAMS", 4);
                table.addColumn("NUM_RESULT_SETS", 4);
                table.addColumn("REMARKS", 12);
                table.addColumn("PROCEDURE_TYPE", 5);
                table.createPrimaryKey();
                return table;
            }
            case 2: {
                Table table = this.createTable(string);
                table.addColumn("PROCEDURE_CAT", 12);
                table.addColumn("PROCEDURE_SCHEM", 12);
                table.addColumn("PROCEDURE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("COLUMN_TYPE", 5);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn("PRECISION", 4);
                table.addColumn("LENGTH", 4);
                table.addColumn("SCALE", 5);
                table.addColumn("RADIX", 5);
                table.addColumn("NULLABLE", 5);
                table.addColumn("REMARKS", 12);
                table.createPrimaryKey();
                return table;
            }
            case 3: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("TABLE_TYPE", 12);
                table.addColumn("REMARKS", 12);
                table.createPrimaryKey();
                int n2 = 0;
                int n3 = this.tTable.size();
                while (n2 < n3) {
                    Table table2 = (Table)this.tTable.elementAt(n2);
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table2.getName();
                    objectArray[3] = "TABLE";
                    table.insert(objectArray, null);
                    ++n2;
                }
                return table;
            }
            case 4: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_SCHEM", 12);
                table.createPrimaryKey();
                return table;
            }
            case 5: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_CAT", 12);
                table.createPrimaryKey();
                return table;
            }
            case 6: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_TYPE", 12);
                table.createPrimaryKey();
                Object[] objectArray = table.getNewRow();
                objectArray[0] = "TABLE";
                table.insert(objectArray, null);
                return table;
            }
            case 7: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn(META_COLUMN_SIZE, 4);
                table.addColumn(META_BUFFER_LENGTH, 4);
                table.addColumn(META_DECIMAL_DIGITS, 4);
                table.addColumn(META_NUM_PREC_RADIX, 4);
                table.addColumn("NULLABLE", 4);
                table.addColumn("REMARKS", 12);
                table.addColumn("COLUMN_DEF", 12);
                table.addColumn("SQL_DATA_TYPE", 12);
                table.addColumn("SQL_DATETIME_SUB", 4);
                table.addColumn("CHAR_OCTET_LENGTH", 4);
                table.addColumn("ORDINAL_POSITION", 12);
                table.addColumn("IS_NULLABLE", 12);
                table.createPrimaryKey();
                int n4 = 0;
                int n5 = this.tTable.size();
                while (n4 < n5) {
                    Table table3 = (Table)this.tTable.elementAt(n4);
                    int n6 = table3.getColumnCount();
                    int n7 = 0;
                    while (n7 < n6) {
                        int n8;
                        Object[] objectArray = table.getNewRow();
                        objectArray[2] = table3.getName();
                        objectArray[3] = table3.getColumn((int)n7).colName;
                        objectArray[4] = new Short((short)table3.getColumn(n7).getType());
                        objectArray[5] = Column.getTypeString(table3.getColumn(n7).getType());
                        objectArray[6] = new Integer(table3.getColumn(n7).getSize());
                        objectArray[8] = new Integer(table3.getColumn(n7).getScale());
                        if (table3.getColumn(n7).isNullable()) {
                            n8 = 1;
                            objectArray[17] = new String("YES");
                        } else {
                            n8 = 0;
                            objectArray[17] = new String("NO");
                        }
                        objectArray[10] = new Integer(n8);
                        if (table3.getIdentityColumn() == n7) {
                            objectArray[11] = "IDENTITY";
                        }
                        objectArray[16] = new Integer(n7 + 1);
                        table.insert(objectArray, null);
                        ++n7;
                    }
                    ++n4;
                }
                return table;
            }
            case 8: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("GRANTOR", 12);
                table.addColumn("GRANTEE", 12);
                table.addColumn("PRIVILEGE", 12);
                table.addColumn("IS_GRANTABLE", 12);
                table.createPrimaryKey();
                return table;
            }
            case 9: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("GRANTOR", 12);
                table.addColumn("GRANTEE", 12);
                table.addColumn("PRIVILEGE", 12);
                table.addColumn("IS_GRANTABLE", 12);
                table.createPrimaryKey();
                int n9 = 0;
                int n10 = this.tTable.size();
                while (n9 < n10) {
                    Table table4 = (Table)this.tTable.elementAt(n9);
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table4.getName();
                    objectArray[3] = "sa";
                    objectArray[5] = "FULL";
                    table.insert(objectArray, null);
                    ++n9;
                }
                return table;
            }
            case 10: {
                Table table = this.createTable(string);
                table.addColumn("SCOPE", 5);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn(META_COLUMN_SIZE, 4);
                table.addColumn(META_BUFFER_LENGTH, 4);
                table.addColumn(META_DECIMAL_DIGITS, 5);
                table.addColumn("PSEUDO_COLUMN", 5);
                table.createPrimaryKey();
                return table;
            }
            case 11: {
                Table table = this.createTable(string);
                table.addColumn("SCOPE", 4);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn(META_COLUMN_SIZE, 5);
                table.addColumn(META_BUFFER_LENGTH, 4);
                table.addColumn(META_DECIMAL_DIGITS, 5);
                table.addColumn("PSEUDO_COLUMN", 5);
                table.createPrimaryKey();
                return table;
            }
            case 12: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("KEY_SEQ", 5);
                table.addColumn("PK_NAME", 12);
                table.createPrimaryKey();
                int n11 = 0;
                int n12 = this.tTable.size();
                while (n11 < n12) {
                    Table table5 = (Table)this.tTable.elementAt(n11);
                    Index index = table5.getIndex("SYSTEM_PK");
                    int[] nArray = index.getColumns();
                    int n13 = nArray.length;
                    int n14 = 0;
                    while (n14 < n13) {
                        Object[] objectArray = table.getNewRow();
                        objectArray[2] = table5.getName();
                        objectArray[3] = table5.getColumn((int)nArray[n14]).colName;
                        objectArray[4] = new Short((short)(n14 + 1));
                        objectArray[5] = "SYSTEM_PK";
                        table.insert(objectArray, null);
                        ++n14;
                    }
                    ++n11;
                }
                return table;
            }
            case 13: {
                Table table = this.createTable(string);
                table.addColumn("PKTABLE_CAT", 12);
                table.addColumn("PKTABLE_SCHEM", 12);
                table.addColumn("PKTABLE_NAME", 12);
                table.addColumn("PKCOLUMN_NAME", 12);
                table.addColumn("FKTABLE_CAT", 12);
                table.addColumn("FKTABLE_SCHEM", 12);
                table.addColumn("FKTABLE_NAME", 12);
                table.addColumn("FKCOLUMN_NAME", 12);
                table.addColumn("KEY_SEQ", 5);
                table.addColumn("UPDATE_RULE", 5);
                table.addColumn("DELETE_RULE", 5);
                table.addColumn("FK_NAME", 12);
                table.addColumn("PK_NAME", 12);
                table.addColumn("DEFERRABILITY", 5);
                table.createPrimaryKey();
                return table;
            }
            case 14: {
                Table table = this.createTable(string);
                table.addColumn("PKTABLE_CAT", 12);
                table.addColumn("PKTABLE_SCHEM", 12);
                table.addColumn("PKTABLE_NAME", 12);
                table.addColumn("PKCOLUMN_NAME", 12);
                table.addColumn("FKTABLE_CAT", 12);
                table.addColumn("FKTABLE_SCHEM", 12);
                table.addColumn("FKTABLE_NAME", 12);
                table.addColumn("FKCOLUMN_NAME", 12);
                table.addColumn("KEY_SEQ", 5);
                table.addColumn("UPDATE_RULE", 5);
                table.addColumn("DELETE_RULE", 5);
                table.addColumn("FK_NAME", 12);
                table.addColumn("PK_NAME", 12);
                table.addColumn("DEFERRABILITY", 5);
                table.createPrimaryKey();
                return table;
            }
            case 15: {
                Table table = this.createTable(string);
                table.addColumn("PKTABLE_CAT", 12);
                table.addColumn("PKTABLE_SCHEM", 12);
                table.addColumn("PKTABLE_NAME", 12);
                table.addColumn("PKCOLUMN_NAME", 12);
                table.addColumn("FKTABLE_CAT", 12);
                table.addColumn("FKTABLE_SCHEM", 12);
                table.addColumn("FKTABLE_NAME", 12);
                table.addColumn("FKCOLUMN_NAME", 12);
                table.addColumn("KEY_SEQ", 4);
                table.addColumn("UPDATE_RULE", 5);
                table.addColumn("DELETE_RULE", 5);
                table.addColumn("FK_NAME", 12);
                table.addColumn("PK_NAME", 12);
                table.addColumn("DEFERRABILITY", 5);
                table.createPrimaryKey();
                return table;
            }
            case 16: {
                Table table = this.createTable(string);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("PRECISION", 4);
                table.addColumn("LITERAL_PREFIX", 12);
                table.addColumn("LITERAL_SUFFIX", 12);
                table.addColumn("CREATE_PARAMS", 12);
                table.addColumn("NULLABLE", 5);
                table.addColumn("CASE_SENSITIVE", 12);
                table.addColumn("SEARCHABLE", 5);
                table.addColumn("UNSIGNED_ATTRIBUTE", -7);
                table.addColumn(META_FIXED_PREC_SCALE, -7);
                table.addColumn("AUTO_INCREMENT", -7);
                table.addColumn("LOCAL_TYPE_NAME", 12);
                table.addColumn("MINIMUM_SCALE", 5);
                table.addColumn("MAXIMUM_SCALE", 5);
                table.addColumn("SQL_DATE_TYPE", 4);
                table.addColumn("SQL_DATETIME_SUB", 4);
                table.addColumn(META_NUM_PREC_RADIX, 4);
                table.createPrimaryKey();
                int n15 = 0;
                while (n15 < Column.TYPES.length) {
                    Object[] objectArray = table.getNewRow();
                    int n16 = Column.TYPES[n15];
                    objectArray[0] = Column.getTypeString(n16);
                    objectArray[1] = new Short((short)n16);
                    objectArray[2] = new Integer(0);
                    objectArray[6] = new Short(1);
                    objectArray[7] = new Boolean(true);
                    objectArray[8] = new Short(3);
                    objectArray[9] = new Boolean(false);
                    objectArray[10] = new Boolean(n16 == 2 || n16 == 3);
                    objectArray[11] = new Boolean(n16 == 4);
                    objectArray[12] = objectArray[0];
                    objectArray[13] = new Short(0);
                    objectArray[14] = new Short(0);
                    objectArray[15] = new Integer(0);
                    objectArray[16] = objectArray[15];
                    objectArray[17] = new Integer(10);
                    table.insert(objectArray, null);
                    ++n15;
                }
                return table;
            }
            case 17: {
                Table table = this.createTable(string);
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("NON_UNIQUE", -7);
                table.addColumn("INDEX_QUALIFIER", 12);
                table.addColumn("INDEX_NAME", 12);
                table.addColumn("TYPE", 5);
                table.addColumn(META_ORDINAL_POSITON, 5);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn(META_ASC_OR_DESC, 12);
                table.addColumn("CARDINALITY", 4);
                table.addColumn("PAGES", 4);
                table.addColumn("FILTER_CONDITION", 12);
                table.createPrimaryKey();
                int n17 = 0;
                int n18 = this.tTable.size();
                while (n17 < n18) {
                    Table table6 = (Table)this.tTable.elementAt(n17);
                    Index index = null;
                    while ((index = table6.getNextIndex(index)) != null) {
                        int[] nArray = index.getColumns();
                        int n19 = index.getVisibleColumns();
                        int n20 = 0;
                        while (n20 < n19) {
                            Object[] objectArray = table.getNewRow();
                            objectArray[2] = table6.getName();
                            objectArray[3] = new Boolean(!index.isUnique());
                            objectArray[5] = index.getName();
                            objectArray[6] = new Short(3);
                            objectArray[7] = new Short((short)(n20 + 1));
                            objectArray[8] = table6.getColumn((int)nArray[n20]).colName;
                            objectArray[9] = "A";
                            table.insert(objectArray, null);
                            ++n20;
                        }
                    }
                    ++n17;
                }
                return table;
            }
            case 18: {
                Table table = this.createTable(string);
                table.addColumn("TYPE_CAT", 12);
                table.addColumn("TYPE_SCHEM", 12);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn("CLASS_NAME", -7);
                table.addColumn("DATA_TYPE", 12);
                table.addColumn("REMARKS", 12);
                table.createPrimaryKey();
                return table;
            }
            case 19: {
                Table table = this.createTable(string);
                table.addColumn("KEY", 12);
                table.addColumn("VALUE", 12);
                table.createPrimaryKey();
                Object[] objectArray = table.getNewRow();
                objectArray[0] = "USER";
                objectArray[1] = channel.getUsername();
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "READONLY";
                objectArray[1] = channel.isReadOnly() ? "TRUE" : "FALSE";
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "MAXROWS";
                objectArray[1] = String.valueOf(channel.getMaxRows());
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "DATABASE";
                objectArray[1] = channel.getDatabase().getName();
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "IDENTITY";
                objectArray[1] = String.valueOf(channel.getLastIdentity());
                table.insert(objectArray, null);
                return table;
            }
            case 20: {
                Table table = this.createTable(string);
                table.addColumn("USER", 12);
                table.addColumn("ADMIN", -7);
                table.createPrimaryKey();
                Vector vector = this.aAccess.getUsers();
                int n21 = 0;
                int n22 = vector.size();
                while (n21 < n22) {
                    String string2;
                    User user = (User)vector.elementAt(n21);
                    if (user != null && !(string2 = user.getName()).equals("PUBLIC")) {
                        Object[] objectArray = table.getNewRow();
                        objectArray[0] = string2;
                        objectArray[1] = new Boolean(user.isAdmin());
                        table.insert(objectArray, null);
                    }
                    ++n21;
                }
                return table;
            }
        }
        return null;
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Channel channel) throws SQLException {
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer;
        Object object3;
        channel.checkAdmin();
        Result result = new Result(1);
        result.colType[0] = 12;
        result.sTable[0] = "SYSTEM_SCRIPT";
        result.sLabel[0] = "COMMAND";
        result.sName[0] = "COMMAND";
        int n2 = 0;
        int n3 = this.tTable.size();
        while (n2 < n3) {
            object3 = (Table)this.tTable.elementAt(n2);
            if (!((Table)object3).isTemp()) {
                int n4;
                Object object4;
                Object object5;
                Object object6;
                if (bl) {
                    this.addRow(result, "DROP TABLE " + ((Table)object3).getStatementName());
                }
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("CREATE ");
                if (((Table)object3).isText()) {
                    stringBuffer.append("TEXT ");
                } else if (((Table)object3).isCached()) {
                    stringBuffer.append("CACHED ");
                }
                stringBuffer.append("TABLE ");
                stringBuffer.append(((Table)object3).getStatementName());
                stringBuffer.append('(');
                n = ((Table)object3).getColumnCount();
                Index index = ((Table)object3).getIndex("SYSTEM_PK");
                object2 = index.getColumns();
                int n5 = 0;
                while (n5 < n) {
                    object = ((Table)object3).getColumn((int)n5).statementName;
                    stringBuffer.append((String)object);
                    stringBuffer.append(' ');
                    String string = Column.getTypeString(((Table)object3).getColumn(n5).getType());
                    stringBuffer.append(string);
                    if (((Table)object3).getColumn(n5).getSize() > 0) {
                        stringBuffer.append("(" + ((Table)object3).getColumn(n5).getSize());
                        if (((Table)object3).getColumn(n5).getScale() > 0) {
                            stringBuffer.append("," + ((Table)object3).getColumn(n5).getScale());
                        }
                        stringBuffer.append(")");
                    }
                    if (((Table)object3).getColumn(n5).getDefaultValue() != null) {
                        stringBuffer.append(" DEFAULT ");
                        stringBuffer.append(Column.createSQLString(((Table)object3).getColumn(n5).getDefaultValue(), ((Table)object3).getColumn(n5).getType()));
                    }
                    if (!((Table)object3).getColumn(n5).isNullable()) {
                        stringBuffer.append(" NOT NULL");
                    }
                    if (n5 == ((Table)object3).getIdentityColumn()) {
                        stringBuffer.append(" IDENTITY");
                    }
                    if (((Object)object2).length == 1 && n5 == object2[0]) {
                        stringBuffer.append(" PRIMARY KEY");
                    }
                    if (n5 < n - 1) {
                        stringBuffer.append(',');
                    }
                    ++n5;
                }
                if (((Object)object2).length > 1) {
                    stringBuffer.append(",CONSTRAINT ");
                    stringBuffer.append("SYSTEM_PK");
                    stringBuffer.append(" PRIMARY KEY");
                    stringBuffer.append(this.getColumnList((Table)object3, (int[])object2, ((Object)object2).length));
                }
                object = ((Table)object3).getConstraints();
                int n6 = 0;
                int n7 = ((Vector)object).size();
                while (n6 < n7) {
                    object6 = (Constraint)((Vector)object).elementAt(n6);
                    if (((Constraint)object6).getType() == 2) {
                        stringBuffer.append(",CONSTRAINT ");
                        stringBuffer.append(((Constraint)object6).getName());
                        stringBuffer.append(" UNIQUE");
                        object5 = ((Constraint)object6).getMainColumns();
                        stringBuffer.append(this.getColumnList(((Constraint)object6).getMain(), (int[])object5, ((Object)object5).length));
                    } else if (((Constraint)object6).getType() == 0) {
                        stringBuffer.append(",CONSTRAINT ");
                        stringBuffer.append(((Constraint)object6).getName());
                        stringBuffer.append(" FOREIGN KEY");
                        object5 = ((Constraint)object6).getRefColumns();
                        stringBuffer.append(this.getColumnList(((Constraint)object6).getRef(), (int[])object5, ((Object)object5).length));
                        stringBuffer.append(" REFERENCES ");
                        stringBuffer.append(((Constraint)object6).getMain().getName());
                        object5 = ((Constraint)object6).getMainColumns();
                        stringBuffer.append(this.getColumnList(((Constraint)object6).getMain(), (int[])object5, ((Object)object5).length));
                        if (((Constraint)object6).isCascade()) {
                            stringBuffer.append(" ON DELETE CASCADE");
                        }
                    }
                    ++n6;
                }
                stringBuffer.append(')');
                this.addRow(result, stringBuffer.toString());
                object6 = null;
                while ((object6 = ((Table)object3).getNextIndex((Index)object6)) != null) {
                    object5 = ((Index)object6).getName();
                    if (((String)object5).equals("SYSTEM_PK") || ((String)object5).startsWith("SYSTEM_FK") || ((String)object5).startsWith("SYSTEM_CT") || ((String)object5).startsWith("SYSTEM_REF")) continue;
                    stringBuffer = new StringBuffer(64);
                    stringBuffer.append("CREATE ");
                    if (((Index)object6).isUnique()) {
                        stringBuffer.append("UNIQUE ");
                    }
                    stringBuffer.append("INDEX ");
                    stringBuffer.append((String)object5);
                    stringBuffer.append(" ON ");
                    stringBuffer.append(((Table)object3).getStatementName());
                    object4 = ((Index)object6).getColumns();
                    n4 = ((Index)object6).getVisibleColumns();
                    stringBuffer.append(this.getColumnList((Table)object3, (int[])object4, n4));
                    this.addRow(result, stringBuffer.toString());
                }
                if (bl2) {
                    object5 = ((Table)object3).getPrimaryIndex();
                    object4 = ((Index)object5).first();
                    n4 = 1;
                    if (object4 != null) {
                        n4 = 0;
                        this.addRow(result, "SET REFERENTIAL_INTEGRITY FALSE");
                    }
                    while (object4 != null) {
                        this.addRow(result, ((Table)object3).getInsertStatement(((Node)object4).getData()));
                        object4 = ((Index)object5).next((Node)object4);
                    }
                    if (n4 == 0) {
                        this.addRow(result, "SET REFERENTIAL_INTEGRITY TRUE");
                    }
                }
                if (((Table)object3).isDataReadOnly()) {
                    stringBuffer = new StringBuffer("SET TABLE ");
                    stringBuffer.append(((Table)object3).getStatementName());
                    stringBuffer.append(" READONLY TRUE");
                    this.addRow(result, stringBuffer.toString());
                }
                if (bl3 && ((Table)object3).isCached()) {
                    stringBuffer = new StringBuffer(128);
                    stringBuffer.append("SET TABLE ");
                    stringBuffer.append(((Table)object3).getStatementName());
                    stringBuffer.append(" INDEX '");
                    stringBuffer.append(((Table)object3).getIndexRoots());
                    stringBuffer.append("'");
                    this.addRow(result, stringBuffer.toString());
                }
                int n8 = TriggerDef.numTrigs();
                int n9 = 0;
                while (n9 < n8) {
                    Vector vector = ((Table)object3).vTrigs[n9];
                    int n10 = vector.size();
                    int n11 = 0;
                    while (n11 < n10) {
                        stringBuffer = ((TriggerDef)vector.elementAt(n11)).toBuf();
                        this.addRow(result, stringBuffer.toString());
                        ++n11;
                    }
                    ++n9;
                }
            }
            ++n2;
        }
        object3 = this.aAccess.getUsers();
        n = 0;
        int n12 = ((Vector)object3).size();
        while (n < n12) {
            object2 = (User)((Vector)object3).elementAt(n);
            if (object2 != null) {
                String string = ((User)object2).getName();
                if (!string.equals("PUBLIC")) {
                    stringBuffer = new StringBuffer(128);
                    stringBuffer.append("CREATE USER ");
                    stringBuffer.append(string);
                    stringBuffer.append(" PASSWORD ");
                    stringBuffer.append("\"" + ((User)object2).getPassword() + "\"");
                    if (((User)object2).isAdmin()) {
                        stringBuffer.append(" ADMIN");
                    }
                    this.addRow(result, stringBuffer.toString());
                }
                if ((object = ((User)object2).getRights()) != null) {
                    Enumeration enumeration = ((Hashtable)object).keys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        int n13 = (Integer)((Hashtable)object).get(string2);
                        if (n13 == 0) continue;
                        stringBuffer = new StringBuffer(64);
                        stringBuffer.append("GRANT ");
                        stringBuffer.append(Access.getRight(n13));
                        stringBuffer.append(" ON ");
                        stringBuffer.append(string2);
                        stringBuffer.append(" TO ");
                        stringBuffer.append(((User)object2).getName());
                        this.addRow(result, stringBuffer.toString());
                    }
                }
            }
            ++n;
        }
        if (this.dDatabase.isIgnoreCase()) {
            this.addRow(result, "SET IGNORECASE TRUE");
        }
        object2 = this.dDatabase.getAlias();
        Enumeration enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)((Hashtable)object2).get(object);
            StringBuffer stringBuffer2 = new StringBuffer(64);
            stringBuffer2.append("CREATE ALIAS ");
            stringBuffer2.append((String)object);
            stringBuffer2.append(" FOR \"");
            stringBuffer2.append(string);
            stringBuffer2.append("\"");
            this.addRow(result, stringBuffer2.toString());
        }
        return result;
    }

    private String getColumnList(Table table, int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 16);
        stringBuffer.append("(");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(table.getColumn((int)nArray[n2]).statementName);
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        return stringBuffer.append(')').toString();
    }

    private void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private Table createTable(String string) throws SQLException {
        return new Table(this.dDatabase, true, string, false, false);
    }

    static {
        String[] stringArray = new String[]{"SYSTEM_PROCEDURES", "SYSTEM_PROCEDURECOLUMNS", "SYSTEM_TABLES", "SYSTEM_SCHEMAS", "SYSTEM_CATALOGS", "SYSTEM_TABLETYPES", "SYSTEM_COLUMNS", "SYSTEM_COLUMNPRIVILEGES", "SYSTEM_TABLEPRIVILEGES", "SYSTEM_BESTROWIDENTIFIER", "SYSTEM_VERSIONCOLUMNS", "SYSTEM_PRIMARYKEYS", "SYSTEM_IMPORTEDKEYS", "SYSTEM_EXPORTEDKEYS", "SYSTEM_CROSSREFERENCE", "SYSTEM_TYPEINFO", "SYSTEM_INDEXINFO", "SYSTEM_UDTS", "SYSTEM_CONNECTIONINFO", "SYSTEM_USERS"};
        int n = 0;
        while (n < stringArray.length) {
            sysTableNames.put(stringArray[n], new Integer(n + 1));
            ++n;
        }
    }
}

