/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.Row;

class BinaryDatabaseRowOutput
extends DatabaseRowOutput {
    private ByteArrayOutputStream byteOut;

    public BinaryDatabaseRowOutput() throws IOException {
        super(new ByteArrayOutputStream());
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public BinaryDatabaseRowOutput(int n) throws IOException {
        super(new ByteArrayOutputStream(n));
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public void writeIntData(int n) throws IOException {
        this.writeInt(n);
    }

    void writeLongData(long l) throws IOException {
        this.writeLong(l);
    }

    void writeNull() throws IOException {
        this.writeInt(0);
    }

    void writeVarNull() throws IOException {
        this.writeNull();
    }

    void writeLongVarNull() throws IOException {
        this.writeNull();
    }

    public void writePos(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeSize(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeType(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeString(String string) throws IOException {
        this.writeUTF(string);
    }

    public void writeVarString(String string) throws IOException {
        this.writeString(string);
    }

    public void writeLongVarString(String string) throws IOException {
        this.writeString(string);
    }

    public void writeByteArray(byte[] byArray) throws IOException {
        this.writeString("**");
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeVarByteArray(byte[] byArray) throws IOException {
        this.writeByteArray(byArray);
    }

    public void writeLongVarByteArray(byte[] byArray) throws IOException {
        this.writeByteArray(byArray);
    }

    public byte[] toByteArray() throws IOException {
        byte[] byArray = this.byteOut.toByteArray();
        this.byteOut.reset();
        return byArray;
    }

    public static int getSize(Row row) {
        Object[] objectArray = row.getData();
        int[] nArray = row.getTable().getColumnTypes();
        return BinaryDatabaseRowOutput.getSize(objectArray, objectArray.length, nArray);
    }

    private static int getSize(Object[] objectArray, int n, int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            n2 += 4;
            if (object != null) {
                switch (nArray[n3]) {
                    case 4: {
                        n2 += 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        n2 += 8;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 1111: {
                        n2 += BinaryDatabaseRowOutput.getUTFsize("**");
                        n2 += 4;
                        n2 += ((ByteArray)object).byteValue().length;
                        break;
                    }
                    default: {
                        n2 += BinaryDatabaseRowOutput.getUTFsize(object.toString());
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    private static int getUTFsize(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2;
    }
}

