/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;

class BinaryDatabaseRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    static final int NO_POS = -1;
    private int pos;
    private int size;

    public BinaryDatabaseRowInput(byte[] byArray, int n) throws IOException {
        super(new ByteArrayInputStream(byArray));
        this.pos = n;
        this.size = byArray.length;
    }

    public BinaryDatabaseRowInput(byte[] byArray) throws IOException {
        this(byArray, -1);
    }

    public int getPos() throws IOException {
        if (this.pos == -1) {
            throw new IOException("No file position specified");
        }
        return this.pos;
    }

    public int getSize() {
        return this.size;
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public long readLongData() throws IOException {
        return this.readLong();
    }

    public String readString() throws IOException {
        return this.readUTF();
    }

    String readVarString() throws IOException {
        return this.readString();
    }

    String readLongVarString() throws IOException {
        return this.readString();
    }

    String readNumericString() throws IOException {
        return this.readString();
    }

    int readType(int n) throws IOException {
        return this.readInt();
    }

    ByteArray readByteArray() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return new ByteArray(byArray);
    }

    ByteArray readVarByteArray() throws IOException {
        return this.readByteArray();
    }

    ByteArray readLongVarByteArray() throws IOException {
        return this.readByteArray();
    }
}

