unit tnu_utils;

interface

uses
    tn_classes;

//procedure
    function WideUpperCase(const Data : WideString) : WideString;
    function WideLowerCase(const Data : WideString) : WideString;
    function WideTrim(const Data : WideString) : WideString;
    function WideTrimLeft(const Data : WideString) : WideString;
    function WideTrimRight(const Data : WideString) : WideString;
    function WideReplace(const Data, A, B : WideString) : WideString;

implementation

function WideUpperCase(const Data : WideString) : WideString;
var
    n : Integer;
    p : PWideChar;
const
    U_ADJUST    =   Byte('a') - Byte('A');
begin
    Result := Data;
    p := PWideChar(Result);
    n := 0;

    while n < Length(Data) do
    begin
        if (p^ >= 'a') and (p^ <= 'z') then
            p^ := WideChar(Word(p^) - U_ADJUST);

        Inc(n);
        Inc(p);
    end;
end;

function WideLowerCase(const Data : WideString) : WideString;
var
    n : Integer;
    p : PWideChar;
const
    U_ADJUST    =   Byte('a') - Byte('A');
begin
    Result := Data;
    p := PWideChar(Result);
    n := 0;

    while n < Length(Data) do
    begin
        if (p^ >= 'A') and (p^ <= 'Z') then
            p^ := WideChar(Word(p^) + U_ADJUST);

        Inc(n);
        Inc(p);
    end;
end;

function WideTrim(const Data : WideString) : WideString;
var
    p : PWideChar;
    start : Integer;
    ends : Integer;
begin
    Result := '';
    p := PWideChar(Data);
    start := 0;
    ends := Length(Data) - 1;

    while start < Length(Data) do
    begin
        if Word((p + start)^) > $20 then Break;
        Inc(start);
    end;

    while ends >= 0 do
    begin
        if Word((p + ends)^) > $20 then Break;
        Dec(ends);
    end;

    if start < ends then
        Result := Copy(Data, start + 1, ends - start + 1)
    else
        Result := Data;
end;

function WideTrimLeft(const Data : WideString) : WideString;
var
    p : PWideChar;
    start : Integer;
    ends : Integer;
begin
    Result := '';
    p := PWideChar(Data);
    start := 0;
    ends := Length(Data) - 1;

    while start < Length(Data) do
    begin
        if Word((p + start)^) > $20 then Break;
        Inc(start);
    end;

    if start < ends then
        Result := Copy(Data, start + 1, ends - start + 1);
end;

function WideTrimRight(const Data : WideString) : WideString;
var
    p : PWideChar;
    ends : Integer;
begin
    Result := '';
    p := PWideChar(Data);
    ends := Length(Data) - 1;

    while ends >= 0 do
    begin
        if Word((p + ends)^) > $20 then Break;
        Dec(ends);
    end;

    if 0 < ends then
        Result := Copy(Data, 1, ends + 1);
end;

function WideReplace(const Data, A, B : WideString) : WideString;
var
    ps : Integer;
    sz : Integer;
    n : Integer;
    pd, pa, pb : PWideChar;
    Memory : TNMemory;
    Found : Boolean;

    function WidePos(p : PWideChar ; Size : Integer) : Integer;
    var
        m, n : Integer;
    begin
        Result := -1;

        for n := 0 to Size - Length(A) do
        begin
            if (p + n)^ = pa^ then
            begin
                Found := True;

                for m := 0 to Length(A) - 1 do
                begin
                    if (pa + m)^ <> (p + n + m)^ then
                    begin
                        Found := False;
                        Break;
                    end;
                end;

                if Found then
                begin
                    Result := n;
                    Exit;
                end;
            end;
        end;
    end;

begin
    if A = '' then
    begin
        Result := Data;
        Exit;
    end;

    Result := '';
    pd := PWideChar(Data);
    pa := PWideChar(A);
    pb := PWideChar(B);
    sz := Length(Data);
    Memory := TNMemory.Create(Length(A));

    while True do
    begin
        ps := WidePos(pd, sz);

        if ps = -1 then
        begin
            //v̂͂Ȃ
            for n := 1 to sz do
            begin
                Memory.PushWideChar(pd^);
                Inc(pd);
            end;

            Break;
        end
        else
        begin
            //v镶܂ŃXLbv
            for n := 1 to ps do
            begin
                Memory.PushWideChar(pd^);
                Inc(pd);
            end;

            //BPUSH
            for n := 0 to Length(B) - 1 do
                Memory.PushWideChar((pb + n)^);

            Dec(sz, ps + 1);
            Inc(pd, Length(A));
        end;
    end;

    Memory.PushWideChar(#0);

    Result := WideString(PWideChar(Memory.Data));
    Memory.Free;
end;


end.
