unit tn_tray;

interface

uses
    windows, messages, shellapi, tn_app, tn_classes;

const
    WM_TRAY         =   WM_USER + 919;

type
    TNTrayIcon      =   class(TNControl)
        private
            FCaption : String;
            FOnQuit : TNotifyEvent;
            nid : TNOTIFYICONDATA;
            procedure Update;
            procedure SetCaption(Value : String);
            procedure SetIcon(Value : HICON);
            procedure WMQuit(var Message : TMessage); message WM_QUIT;
            procedure WMTray(var Message : TMessage); message WM_TRAY;
            procedure PopupMenu(Menu : HMENU);
        public
            LeftMenu : HMENU;
            RightMenu : HMENU;
            constructor Create;
            destructor Destroy; override;
            property Caption : String read FCaption write SetCaption;
            property Icon : HICON read nid.hIcon write SetIcon;
            property OnQuit : TNotifyEvent read FOnQuit write FOnQuit;
    end;

implementation

constructor TNTrayIcon.Create;
begin
    inherited Create('',0);

    FCaption := '';
    nid.cbSize := SizeOf(TNOTIFYICONDATA);
    nid.uID := 1;
    nid.Wnd := Handle;
    nid.uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
    nid.uCallbackMessage := WM_TRAY;
    nid.hIcon := 0;
    lstrcpy(nid.szTip,PChar(FCaption));
end;

destructor TNTrayIcon.Destroy;
begin
    Shell_NotifyIcon(NIM_DELETE, @nid);
    inherited Destroy;
end;

procedure TNTrayIcon.Update;
begin
    if not Shell_NotifyIcon(NIM_MODIFY, @nid) then
        Shell_NotifyIcon(NIM_ADD, @nid)
end;

procedure TNTrayIcon.SetCaption(Value : String);
begin
    if Length(Value) > 64 then Exit;
    FCaption := Value;
    lstrcpy(nid.szTip,PChar(FCaption));
    Update;
end;

procedure TNTrayIcon.SetIcon(Value : HICON);
begin
    nid.hIcon := Value;
    Update;
end;

procedure TNTrayIcon.WMQuit(var Message : TMessage);
begin
    if Assigned(FOnQuit) then FOnQuit(Self);
end;

procedure TNTrayIcon.WMTray(var Message : TMessage);
begin
    case Message.lParam of
        WM_LBUTTONUP:
            PopupMenu(LeftMenu);
        WM_RBUTTONUP:
            PopupMenu(RightMenu);
    end;
end;

procedure TNTrayIcon.PopupMenu(Menu : HMENU);
var
    tp : TPoint;
begin
    SetForegroundWindow(Handle);
    GetCursorPos(tp);
    TrackPopupMenu(Menu,TPM_LEFTALIGN or TPM_RIGHTBUTTON,tp.x,tp.y,0,Handle,nil);
end;

end.
