unit tn_server;

interface

uses
    winsock, tn_classes, tn_utils;

type
    TNServerThread  =   class(TNThread)
        private
		protected
            Socket : TSocket;
			procedure Execute; override;
        public
            Connected : Boolean;
            TimeOut :Integer;
            constructor Create(NewSocket : TSocket);
            destructor Destroy; override;
            procedure Close;
            function SocketCheck : Boolean;
            function Read(Buf : Pointer ; Size : Integer) : Integer;
            function Write(Buf : Pointer ; Size : Integer) : Integer;
            function ReadLine : String;
            procedure SendString(Data : String);
            procedure SendCommand(SendString : String);
            function GetPeerAddress : String;
            function GetPeerHost : String;
			function GetLocalHost : String;
    end;

    TNServerSocket  =   class(TNThread)
		protected
			procedure Execute; override;
        public
            Error : Boolean;
            Port : Integer;
            Socket : TSocket;
            TimeOut : Integer;
            constructor Create(PortNum : Integer); virtual;
            destructor Destroy; override;
            procedure ThreadStart(NewSocket : TSocket); virtual;
    end;

implementation

//******************************************************************************
// TNServerThread

constructor TNServerThread.Create(NewSocket : TSocket);
begin
    Socket := NewSocket;
    Connected := True;
    TimeOut := 30;
    inherited Create(False);
end;

destructor TNServerThread.Destroy;
begin
    Close;
end;

procedure TNServerThread.Close;
begin
    if Connected then
    begin
        Winsock.closesocket(Socket);
        Socket := INVALID_SOCKET;
        Connected := False;
    end;
end;

function TNServerThread.SocketCheck : Boolean;
var
    SockAddr : TSockAddr;
    Value : Integer;
begin
    Result := False;
    if not Connected then Exit;

    if Socket = INVALID_SOCKET then
        Connected := False
    else
    begin
        Value := SizeOf(TSockAddr);

        if getpeername(Socket, SockAddr, Value) = 0 then
            Result := True
        else
            Connected := False;
    end;
end;

function TNServerThread.Read(Buf : Pointer ; Size : Integer) : Integer;
var
    Flag : Integer;
    FDSet : TFDSet;
    Tm: TTimeVal;
begin
    Result := 0;
    if not SocketCheck then Exit;

    Tm.tv_sec := Timeout;
    Tm.tv_usec := 0;
    FD_ZERO(FDSet);
    FD_SET(Socket, FDSet);
    Flag := select(Socket, @FDSet, nil, nil, @Tm);

    if (Flag = 0) or (Flag = SOCKET_ERROR) then
    begin
        Close;
        Exit;
    end;

    Result := recv(Socket, Buf^, Size, 0);
end;

function TNServerThread.Write(Buf : Pointer ; Size : Integer) : Integer;
var
    Flag : Integer;
    FDSet : TFDSet;
    Tm: TTimeVal;
begin
    Result := 0;
    if not SocketCheck then Exit;

    Tm.tv_sec := Timeout;
    Tm.tv_usec := 0;
    FD_ZERO(FDSet);
    FD_SET(Socket, FDSet);
    Flag := select(Socket, nil, @FDSet, nil, @Tm);
    Result := send(Socket, Buf^, Size, 0);

    if (Flag = 0) or (Result = SOCKET_ERROR) then Close;
    if Result = SOCKET_ERROR then Close;
end;

function TNServerThread.ReadLine : String;
var
    ch : Char;
begin
    Result := '';

    while SocketCheck do
    begin
        Read(@ch, 1);
        Result := Result + ch;
        if ch = #10 then Break;
        if ch = #0 then Break;
    end;

    Result := AdjustLineBreaks(Result);
end;

procedure TNServerThread.SendString(Data : String);
begin
    if not SocketCheck then Exit;

    Self.Write(PChar(Data), Length(Data));
end;

procedure TNServerThread.SendCommand(SendString : String);
var
    Cmd : String;
begin
    if not SocketCheck then Exit;

    Cmd := SendString + #13#10;
    Self.Write(PChar(Cmd), Length(Cmd));
end;

function TNServerThread.GetPeerAddress : String;
var
    Host : sockaddr_in;
    Size : Integer;
    P : PChar;
begin
    Result := '';
    Size := SizeOf(Host);

    getpeername(Socket, Host, Size);
    P := inet_ntoa(Host.sin_addr);

    if P <> nil then
        Result := String(P);
end;

function TNServerThread.GetPeerHost : String;
var
    Host : sockaddr_in;
    Size : Integer;
    P : PHostEnt;
begin
    Result := '';
    Size := SizeOf(Host);
    getpeername(Socket, Host, Size);
    P := gethostbyaddr(@Host.sin_addr, 4, PF_INET);

    if P <> nil then
        Result := String(P.h_name)
    else
        Result := '';
end;

function TNServerThread.GetLocalHost : String;
type
	TInAddrList = array[0..100] of PInAddr;
    PInAddrList = ^TInAddrList;
var
	n : Integer;
    temp : String;
    buf : array [0..511] of Char;
    pent : PHostEnt;
    in_addr : TInAddr;
    list : TNStringList;
begin
    gethostname(buf, SizeOf(buf));
    pent := gethostbyname(buf);
	n := 0;
    list := TNStringList.Create;

	while PInAddrList(pent^.h_addr_list)^[n] <> nil do
	begin
		in_addr  :=PInAddrList(pent^.h_addr_list)^[n]^;
        list.Add(String(inet_ntoa(in_addr)));
		Inc(n);
	end;

    //127.0.0.1łȂ192.168.*.*łȂc
    for n := 0 to list.Count - 1 do
    begin
    	temp := Trim(list.Strings[n]);

        if (temp <> '127.0.0.1') and (Copy(temp, 1, 8) <> '192.168.') then
        begin
        	list.Free;
        	Result := temp;
            Exit;
        end;
    end;

    //127.0.0.1ł͂Ȃ...
    for n := 0 to list.Count - 1 do
    begin
    	temp := Trim(list.Strings[n]);

        if temp <> '127.0.0.1' then
        begin
        	list.Free;
        	Result := temp;
            Exit;
        end;
    end;

	//127.0.0.1Ɍ
	list.Free;
    Result := '127.0.0.1';
end;

procedure TNServerThread.Execute;
begin

end;

//******************************************************************************
//

constructor TNServerSocket.Create(PortNum : Integer);
var
    Dummy : WSADATA;
begin
	//\Pbg̏
	WSAStartup($0101, Dummy);
    Socket := INVALID_SOCKET;
    Port := PortNum;
    TimeOut := 30;
    Error := False;

    inherited Create(False);
end;

destructor TNServerSocket.Destroy;
begin
    WSACleanup;
    inherited Destroy;
end;

procedure TNServerSocket.Execute;
var
	NewSocket : TSocket;
	Address : TSockAddrIn;
	n : Integer;
    Opt : Integer;
	Size : Integer;
begin
	//Address\̂̐ݒ
    FillChar((@Address)^,SizeOf(TSockAddrIn),#0);
	Address.sin_family := PF_INET;
	Address.sin_port := htons(Port);
	Address.sin_addr.S_addr := INADDR_ANY;
    Size := SizeOf(Address);

	//\Pbg
    Socket := Winsock.socket(PF_INET, SOCK_STREAM, IPPROTO_IP);

    if (Socket = INVALID_SOCKET) or (Socket = 0) then
	begin
        //\PbgG[
		Error := True;
        Exit;
	end;

	//oCh
	n := Winsock.bind(Socket, Address, SizeOf(Address));

	if n = SOCKET_ERROR then
	begin
        //oChG[
		Error := True;
        CloseSocket(Socket);
        Exit;
	end;

	//X
	n := winsock.listen(Socket, SOMAXCONN);
	if n = SOCKET_ERROR then
	begin
		Error := True;
        CloseSocket(Socket);
        Exit;
	end;

	//\PbgIvV̐ݒ
    setsockopt(Socket, SOL_SOCKET, SO_REUSEADDR, @Opt, SizeOf(Opt));

	//ANZvg[v
	while True do
	begin
		NewSocket := accept(Socket, @Address, @size);

		if NewSocket = INVALID_SOCKET then
		begin
			Error := True;
            CloseSocket(Socket);
            Exit;
		end;

        //Xbh̊Jn
        ThreadStart(NewSocket);
	end;
end;

procedure TNServerSocket.ThreadStart(NewSocket : TSocket);
begin
    //I[o[ChĎgp
    Winsock.closesocket(NewSocket);
end;

end.
