unit tn_md5sup;

interface

uses
    md5;

type
    TRequest = record
        Algorithm : String;
        Method : String;
        Nonce : String;
        Pass : String;
        Qop : String;
        Realm : String;
        URI : String;
        User : String;
    end;

function HexCode(Ch : Byte) : String;
function CvtHex(Hash : MD5Digest) : String;
function MD5Encode(Source : String) : String;
function Digest_Response(Request : TRequest) : String;

implementation

function HexCode(Ch : Byte) : String;
    function NumCode(n : Byte) : String;
    var
        m : Byte;
    begin
        Result := '';
        m := n;
        if m < 10 then
            Result := Chr(Ord('0')+m)
        else
        begin
            m := m - 10;
            Result := Chr(Ord('a')+m);
        end;
    end;
var
    a , b : Byte;
begin
    a := Ch div 16;
    b := Ch mod 16;
    Result := NumCode(a) + NumCode(b);
end;

function CvtHex(Hash : MD5Digest) : String;
var
    n : Integer;
begin
    Result := '';
    for n := 0 to 15 do
        Result := Result + HexCode(Ord(Hash[n]));
end;

function MD5Encode(Source : String) : String;
var
    Ans : MD5Digest;
begin
    Ans := MD5String(Source);
    Result := Cvthex(Ans);
end;

function Digest_Response(Request : TRequest) : String;
var
    Md5Ctx : MD5Context;
    HA1 , HA2 , RespHash : MD5Digest;
    pszCNonce , pszNonceCount , HEntity , HA1HEX , HA2Hex : String;
begin
    pszNonceCount := '00000001';
    pszCNonce := MD5Encode(Request.Nonce);

    MD5Init(Md5Ctx);
    MD5Update( Md5Ctx , PChar(Request.User) , Length(Request.User) );
    MD5Update( Md5Ctx , ':',1);
    MD5Update( Md5Ctx , PChar(Request.Realm) , Length(Request.Realm) );
    MD5Update( Md5Ctx , ':',1);
    MD5Update( Md5Ctx , PChar(Request.Pass) , Length(Request.Pass) );
    MD5Final( Md5Ctx , HA1 );

    if Request.Algorithm = 'md5-sess' then
    begin
        MD5Init(Md5Ctx);
        MD5Update(Md5Ctx , @HA1 , HASHLEN);
        MD5Update(Md5Ctx , ':', 1);
        MD5Update(Md5Ctx , PChar(Request.Nonce) , Length(Request.Nonce));
        MD5Update(Md5Ctx , ':', 1);
        pszCNonce := MD5Encode(Request.Nonce);
        MD5Update(Md5Ctx , PChar(pszCNonce) , Length(pszCNonce));
        MD5Final(Md5Ctx , HA1);
    end;

    HA1HEX := CvtHex(HA1);

    MD5Init(Md5Ctx);
    MD5Update(Md5Ctx, PChar(Request.Method), Length(Request.Method));
    MD5Update(Md5Ctx, ':', 1);
    MD5Update(Md5Ctx, PChar(Request.URI), Length(Request.URI));

    HEntity := StringOfChar(#0,32);

    if Request.Qop = 'auth-int' then
    begin
        MD5Update(Md5Ctx, ':', 1);
        MD5Update(Md5Ctx, PChar(HEntity), HASHHEXLEN);
    end;

    MD5Final(Md5Ctx , HA2);

    HA2Hex := CvtHex(HA2);

    MD5Init(Md5Ctx);
    MD5Update(Md5Ctx, PChar(HA1HEX), HASHHEXLEN);
    MD5Update(Md5Ctx, ':', 1);
    MD5Update(Md5Ctx, PChar(Request.Nonce), Length(Request.Nonce));
    MD5Update(Md5Ctx, ':', 1);

    if Request.Qop <> '' then
    begin
        MD5Update(Md5Ctx, PChar(pszNonceCount), Length(pszNonceCount));
        MD5Update(Md5Ctx, ':', 1);
        MD5Update(Md5Ctx, PChar(pszCNonce), Length(pszCNonce));
        MD5Update(Md5Ctx, ':', 1);
        MD5Update(Md5Ctx, PChar(Request.Qop), Length(Request.Qop));
        MD5Update(Md5Ctx, ':', 1);
    end;

    MD5Update(Md5Ctx, PChar(HA2Hex), HASHHEXLEN);
    MD5Final(Md5Ctx, RespHash);
    Result := 'Authorization: Digest username="' + Request.User
                +'", realm="' + Request.Realm + '", qop="' + Request.Qop
                + '", algorithm="' + Request.Algorithm + '", uri="'
                + Request.URI+ '", nonce="' + Request.Nonce
                + '", nc=00000001, cnonce="' + pszCNonce
                + '", response="' + CvtHex(RespHash) + '"';
end;
end.
