unit tn_http;

interface

uses
    windows, tn_socket, tn_classes, tn_utils, tn_internet, tn_md5sup, tn_inet;

type
    PBoolean    =   ^Boolean;
    TQuoteType  =   (qtNone, qtSingle, qtDouble);

    THttpInfo   =   record
        Method : String;    //Method
        URL : String;       //URL
        PostData : String;  //Option Data
        Host : String;      //Host Address
        Port : Integer;     //Host Port
        Proxy_Addr : String;
        Proxy_Port : Integer;
        Version : String;
        Path : String;
        Protocol : String;
        Header : String;
    end;

    TNhttp      =   class
        private
            Inet : TNInet;
            Buf : array [0..4095] of Char;
        public
            ExitFlag : PBoolean;
            ErrorNum : Integer;
            ErrorMsg : String;
            constructor Create;
            destructor Destroy; override;
            function Post(var Info : THttpInfo) : String;
            function PostInet(var Info : THttpInfo) : String;
    end;

//procedure
    procedure DevideURL(URL : String; var Protocol : String ; var Host : String ; var Path : String ; var Port : Integer);
    function GenerateAuthHeader(Method : String ; URI : String ; Data : String ; User : String ; Pass : String) : String;
    function SplitRoot(URL : String) : String;
    function SplitCurrentDir(URL : String) : String;
    function SplitCurrentParent(URL : String) : String;
    function AbsoluteUrl(CurrentURL : String ; Relative : String) : String;
    function GetSingleFile(URL : String) : String;
    function UrlCheck(URL : String) : String;

    function URLDownload(URL : String ; ProxyAddr : String ; ProxyPort : Integer) : String;

implementation

//******************************************************************************
//TNhttp

constructor TNhttp.Create;
begin
    Inet := TNInet.Create;
    ExitFlag := nil;
end;

destructor TNhttp.Destroy;
begin
    Inet.Free;
    inherited Destroy;
end;

function TNhttp.Post(var Info : THttpInfo) : String;
var
    Socket : TNSocket;
    temp : String;
    ps : Integer;
    RealSize : Integer;
begin
    Result := '';
    Info.Header := '';
    ErrorNum := 0;
    Socket := TNSocket.Create;

    if Info.Proxy_Addr = '' then
    begin
        //Pattern1. i}ŃT[oɐڑ
        if not Socket.Connect(Info.Host, Info.Port) then
        begin
            Socket.Free;
            Exit;
        end;
    end
    else
    begin
        //Pattern2. vLVoRŃT[oɐڑ
        if not Socket.Connect(Info.Proxy_Addr, Info.Proxy_Port) then
        begin
            Socket.Free;
            Exit;
        end;
    end;

    //𑗐M
    Socket.SendString(Info.PostData);

    //ŏ̍so
    temp := Trim(Socket.ReadLine);
    ps := Pos(' ', temp);
    Info.Header := temp + #13#10;

    if ps = 0 then
    begin
        Socket.Free;
        Exit;
    end;

    //G[ԍ擾
    temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    ps := Pos(' ', temp);

    if ps = 0 then
        ErrorNum := StrToInt(temp)
    else
    begin
        ErrorNum := StrToInt(Copy(temp, 1, ps - 1));

        //G[bZ[W擾
        ErrorMsg := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    end;

    //wb_擾
    temp := Socket.ReadLine;

    while Trim(temp) <> '' do
    begin
        Info.Header := Info.Header + temp;
        temp := Socket.ReadLine;
    end;

    //ؒf܂Ńf[^擾
    RealSize := Socket.Read(@Buf, SizeOf(Buf));

    while (Socket.SocketCheck) and (RealSize > 0) do
    begin
        if (ExitFlag <> nil) and (ExitFlag^) then Break;
        Result := Result + Copy(Buf, 1, RealSize);
        RealSize := Socket.Read(@Buf, SizeOf(Buf));
    end;

    //\Pbg
    Socket.Close;
    Socket.Free;
end;

function TNhttp.PostInet(var Info : THttpInfo) : String;
var
    OpenHandle : HINTERNET;
    ConHandle : HINTERNET;
    ReqHandle : HINTERNET;
    TimeOut : Integer;
    n : Integer;
    Flags : Cardinal;
    HeaderBuf : array [0..65535] of Char;
    Size : Cardinal;
    rs : Cardinal;
    ps : Integer;
    temp : String;
    Proxy : String;
    PostHeader : String;
    PostData : String;
begin
    Info.Header := '';
    ErrorNum := 0;
    ErrorMsg := '';
    Result := '';

    Inet.InternetAttemptConnect(0);

    if not InetLoaded then Exit;
    Proxy := Info.Proxy_Addr + ':' + IntToStr(Info.Proxy_Port);

    if Info.Proxy_Addr = '' then
        OpenHandle := Inet.InternetOpen(nil, INTERNET_OPEN_TYPE_DIRECT
                                                            , nil, nil, 0)
    else
        OpenHandle := Inet.InternetOpen(nil, INTERNET_OPEN_TYPE_PROXY
                                            , PChar(Proxy) , nil, 0);

    if OpenHandle = nil then Exit;

    //^CAEgݒ
    TimeOut := 60000;

    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_CONNECT_TIMEOUT
                                                , @TimeOut, SizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT
                                                , @TimeOut, sizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_CONTROL_SEND_TIMEOUT
                                                , @TimeOut, sizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_DATA_SEND_TIMEOUT
                                                , @TimeOut, SizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_DATA_RECEIVE_TIMEOUT
                                                , @TimeOut, SizeOf(TimeOut));

    //ڑ
    for n := 1 to 5 do
    begin
        ConHandle := Inet.InternetConnect(OpenHandle, PChar(Info.Host)
                        , Info.Port , nil, nil, INTERNET_SERVICE_HTTP
                        , 0, 0);
        if ConHandle <> nil then Break;
    end;

    if ConHandle = nil then
    begin
        Inet.InternetCloseHandle(OpenHandle);
        Exit;
    end;

    Flags := INTERNET_FLAG_RELOAD or INTERNET_FLAG_HYPERLINK or
                INTERNET_FLAG_NO_UI or INTERNET_FLAG_NO_AUTO_REDIRECT;

    if Info.Protocol = 'https' then
        Flags := Flags or INTERNET_FLAG_SECURE
                    or INTERNET_FLAG_IGNORE_CERT_DATE_INVALID;

    ReqHandle := Inet.HttpOpenRequest(ConHandle, PChar(Info.Method)
                                    , PChar(Info.Path), PChar(Info.Version)
                                        , nil, nil, Flags, 0);

    //|Xgf[^ēxo
    ps := Pos(#13#10, Info.PostData);
    PostHeader := Copy(Info.PostData, ps + 2, Length(Info.PostData) - ps - 1);
    ps := Pos(#13#10#13#10, PostHeader);
    PostData := Copy(PostHeader, ps + 4, Length(PostHeader) - ps - 3);
    PostHeader := Copy(PostHeader, 1, ps - 1);
    //ps := Pos(#13#10#13#10, PostData);
    //PostData := Copy(PostData, 1, ps - 1);

    if not Inet.HttpSendRequest(ReqHandle, PChar(PostHeader)
        , Length(PostHeader), PChar(PostData), Length(PostData)) then
    begin
        Inet.InternetCloseHandle(ConHandle);
        Inet.InternetCloseHandle(OpenHandle);
        Exit;
    end;

    Size := SizeOf(HeaderBuf);
    rs := 0;

    if not Inet.HttpQueryInfo(ReqHandle,
           HTTP_QUERY_RAW_HEADERS_CRLF,// or HTTP_QUERY_CUSTOM,
           @HeaderBuf, Size, rs) then Exit;

    //wb_o
    Info.Header := AdjustLineBreaks(Copy(HeaderBuf, 1, Size));
    ps := Pos(#13#10, Info.Header);
    temp := Trim(Copy(Info.Header, 1, ps - 1));
    ps := Pos(' ', temp);

    if ps <> 0 then
        temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));

    ps := Pos(' ', temp);

    if ps <> 0 then
    begin
        ErrorNum := StrToInt(Trim(Copy(temp, 1, ps - 1)));
        temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    end;

    ErrorMsg := temp;

    //wb_݂̂ɂ
    ps := Pos(#13#10, Info.Header);
    Info.Header := Copy(Info.Header, ps + 2, Length(Info.Header) - ps - 1);

    //ؒf܂Ńf[^擾
    Size := 0;

    while (Inet.InternetReadFile(ReqHandle,@Buf,SizeOf(Buf),Size)) and (Size > 0) do
    begin
        //Info.Source := Info.Source + Copy(Buf, 1, Size);
        if (ExitFlag <> nil) and (ExitFlag^) then Break;
        Result := Result + Copy(Buf, 1, Size);
    end;

    //nhJ
    if ReqHandle <> nil then
        Inet.InternetCloseHandle(ReqHandle);

    if ConHandle <> nil then
        Inet.InternetCloseHandle(ConHandle);

    if OpenHandle <> nil then
        Inet.InternetCloseHandle(OpenHandle);
end;

//******************************************************************************
//Procedures

procedure DevideURL(URL : String; var Protocol : String ; var Host : String
                                    ; var Path : String ; var Port : Integer);
var
    ps : Integer;
    temp : String;
begin
    //vgR擾
    ps := Pos('://', URL);
    if ps = 0 then Exit;
    Protocol := Copy(URL, 1, ps - 1);

    //vgRȊO̕擾
    temp := Copy(URL, ps + 3, Length(URL) - ps - 1);

    //zXg擾
    ps := Pos('/', temp);
    Host := Copy(temp, 1, ps - 1);
    Port := 0;

    if ps = 0 then
    begin
        Path := '/';
    end
    else
    begin
        Host := Copy(temp, 1, ps - 1);
        Path := Copy(temp, ps, Length(temp) - ps + 1);
    end;

    //ڑ|[g擾
    ps := Pos(':', Host);

    if ps <> 0 then
    begin
        Port := StrToInt(Copy(Host, ps + 1, Length(Host) - ps));
        Host := Copy(Host, 1, ps - 1);
    end;

    if Port = 0 then
    begin
        if Protocol = 'ftp' then
            Port := INTERNET_DEFAULT_FTP_PORT
        else if Protocol = 'http' then
            Port := INTERNET_DEFAULT_HTTP_PORT
        else if Protocol = 'https' then
            Port := INTERNET_DEFAULT_HTTPS_PORT;
    end;
end;

function GenerateAuthHeader(Method : String ; URI : String ; Data : String
                                    ; User : String ; Pass : String) : String;
var
    temp : String;
    stemp : String;
    ttemp : String;
    ps : Integer;
    Ln : Integer;
    n : Integer;
    Src : PChar;
    ch : Char;
    QuotType : TQuoteType;
    Request : TRequest;
    List : TNStringList;
begin
    Result := '';
    List := TNStringList.Create;
    List.Text := Trim(Data);

    for n := 0 to List.Count - 1 do
    begin
        temp := List.Strings[n];

        if UpperCase(Copy(temp, 1, 5)) = 'BASIC' then
        begin
            //BASICF
            Result := 'Authorization: Basic '
                        + Base64Encode(User + ':' + Pass) + #13#10;
            Break;
        end
        else if UpperCase(Copy(temp, 1, 6)) = 'DIGEST' then
        begin
            //DIGESTF
            temp := Copy(temp, 7, Length(temp) - 6);

            //
            Ln := Length(temp);
            Src := PChar(temp);
            stemp := UpperCase(temp);
            Request.Algorithm := 'MD5';
            Request.Method := Method;
            Request.Pass := Pass;
            Request.User := User;
            Request.URI := URI;

            //realm
            ps := Pos('REALM=', stemp);

            if ps <> 0 then
            begin
                ps := ps + 5;
                ttemp := '';
                QuotType := qtNone;

                while ps < Ln do
                begin
                    ch := (Src + ps)^;

                    case ch of
                        ';', ' ', ',':
                            begin
                                if QuotType = qtNone then
                                    Break;
                            end;

                        '"':
                            begin
                                if QuotType = qtNone then
                                    QuotType := qtDouble
                                else if QuotType = qtDouble then
                                    QuotType := qtNone;
                            end;

                    end;

                    ps := ps + 1;
                    ttemp := ttemp + ch;
                end;

                ttemp := Trim(ttemp);

                if ttemp <> '' then
                begin
                    if ttemp[1] = '"' then
                        ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
                end;

                Request.Realm := ttemp;
            end;

            //nonce
            ps := Pos('NONCE=', stemp);

            if ps <> 0 then
            begin
                ps := ps + 5;
                ttemp := '';
                QuotType := qtNone;

                while ps < Ln do
                begin
                    ch := (Src + ps)^;

                    case ch of
                        ';', ' ', ',':
                            begin
                                if QuotType = qtNone then
                                    Break;
                            end;

                        '"':
                            begin
                                if QuotType = qtNone then
                                    QuotType := qtDouble
                                else if QuotType = qtDouble then
                                    QuotType := qtNone;
                            end;

                    end;

                    ps := ps + 1;
                    ttemp := ttemp + ch;
                end;

                ttemp := Trim(ttemp);

                if ttemp <> '' then
                begin
                    if ttemp[1] = '"' then
                        ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
                end;

                Request.Nonce := ttemp;
            end;

            //qop
            ps := Pos('QOP=', stemp);

            if ps <> 0 then
            begin
                ps := ps + 3;
                ttemp := '';
                QuotType := qtNone;

                while ps < Ln do
                begin
                    ch := (Src + ps)^;

                    case ch of
                        ';', ' ', ',':
                            begin
                                if QuotType = qtNone then
                                    Break;
                            end;

                        '"':
                            begin
                                if QuotType = qtNone then
                                    QuotType := qtDouble
                                else if QuotType = qtDouble then
                                    QuotType := qtNone;
                            end;
                    end;

                    ps := ps + 1;
                    ttemp := ttemp + ch;
                end;

                ttemp := Trim(ttemp);

                if ttemp <> '' then
                begin
                    if ttemp[1] = '"' then
                        ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
                end;

                Request.Qop := ttemp;
            end;

            Result := Digest_Response(Request) + #13#10;
            Break;
        end;
    end;

    List.Free;
end;

function SplitRoot(URL : String) : String;
var
    Src : PChar;
    ch : Char;
    ps : Integer;
    Index : Integer;
begin
    Result := '';
    Src := PChar(URL);
    ps := Pos('//', URL);

    if ps <> 0 then
    begin
        Result := Copy(URL, 1, ps + 1);
        Index := ps + 1;

        while Index < Length(URL) do
        begin
            ch := (Src + Index)^;

            if ch = '/' then
                Break
            else
                Result := Result + ch;

            Index := Index + 1;
        end;
    end;
end;

function SplitCurrentDir(URL : String) : String;
var
    Src : PChar;
    ps : Integer;
    Index : Integer;
begin
    Result := '';
    Src := PChar(URL);
    ps := Pos('//', URL);

    if ps <> 0 then
    begin
        Index := Length(URL) - 1;

        while Index > ps do
        begin
            if (Src + Index)^ = '/' then
                Break;

            Index := Index - 1;
        end;

        Result := Copy(URL, 1, Index + 1);
    end;
end;

function SplitCurrentParent(URL : String) : String;
var
    NewUrl : String;
    Src : PChar;
    ps : Integer;
    Index : Integer;
begin
    Result := '';
    NewUrl := SplitCurrentDir(URL);

    if NewUrl = '' then Exit;
    if NewUrl[Length(NewUrl)] <> '/' then Exit;

    NewUrl := Copy(NewUrl, 1, Length(NewUrl) - 1);
    Src := PChar(NewUrl);
    ps := Pos('//', NewUrl);
    Index := Length(NewUrl) - 1;

    while Index > ps do
    begin
        if (Src + Index)^ = '/' then
            Break;

        Index := Index - 1;
    end;

    Result := Copy(NewUrl, 1, Index + 1);
end;

function AbsoluteUrl(CurrentURL : String ; Relative : String) : String;
var
    CurrentDir : String;
    ParentDir : String;
    RootDir : String;
begin
    if Pos('//', Relative) <> 0 then
    begin
        Result := Relative;
        Exit;
    end;

    Result := '';
    if Relative = '' then Exit;

    CurrentDir := SplitCurrentDir(CurrentURL);
    ParentDir := SplitCurrentParent(CurrentURL);
    RootDir := SplitRoot(CurrentURL);

    if Copy(Relative, 1, 2) = './' then
        Result := CurrentDir + Copy(Relative, 3, Length(Relative) - 2)
    else if Copy(Relative, 1, 3) = '../' then
        Result := CurrentDir + Copy(Relative, 3, Length(Relative) - 2)
    else if Relative[1] = '/' then
//        Result := RootDir + Copy(Relative, 2, Length(Relative) - 1)
        Result := RootDir + Relative
    else
        Result := CurrentDir + Relative;
end;

function GetSingleFile(URL : String) : String;
var
    Index : Integer;
    temp : String;
    n : Integer;
begin
    Result := '';
    temp := URL;
    Index := Pos('?', temp);

    if Index <> 0 then
        temp := Copy(temp, 1, Index - 1);

    for n := Length(temp) downto 1 do
    begin
        if temp[n] = '/' then
        begin
            Result := Copy(temp, n + 1, Length(temp) - n);
            Break;
        end;
    end;

    if Result = '' then
        Result := 'index.htm';
end;

function UrlCheck(URL : String) : String;
var
    ps : Integer;
    temp : String;
begin
    Result := URL;

    ps := Pos('//', URL);

    if ps <> 0 then
    begin
        temp := Copy(URL, ps + 2, Length(URL) - ps - 1);

        if Pos('/', temp) = 0 then
            Result := Result + '/';
    end;
end;

//******************************************************************************

function URLDownload(URL : String ; ProxyAddr : String
                                                ; ProxyPort : Integer) : String;
var
    Http : TNHttp;
    Info : THttpInfo;
begin
    //
    Http := TNHttp.Create;
    Info.Method := 'GET';
    Info.URL := URL;
    Info.Proxy_Addr := ProxyAddr;
    Info.Proxy_Port := ProxyPort;
    Info.Version := 'HTTP/1.0';
    Info.Protocol := 'http';
    Info.Header := '';

    //URLvf𕪗
    DevideURL(URL, Info.Protocol, Info.Host, Info.Path, Info.Port);

    //|Xgf[^𐶐
    if ProxyAddr <> '' then
    begin
        Info.PostData :=    'GET ' + URL + ' ' + Info.Version + #13#10
                        +   'Host: ' + Info.Host + #13#10#13#10;
    end
    else
    begin
        Info.PostData :=    'GET ' + Info.Path + ' ' + Info.Version + #13#10
                        +   'Host: ' + Info.Host + #13#10#13#10;
    end;

    Result := Http.Post(Info);
    if Http.ErrorNum <> 200 then Result := '';
end;

end.
