unit tn_codeexchg;

interface

uses
	tn_utils;

    //Base 64֘A֐
    function Base64Decode(const S : String) : String;
    function Base64Encode(const S : String) : String;
    //HTML <->eLXgϊ֐
    function HTMLtoText(const Source : String) : String;
    function TexttoHTML(const Source : String) : String;
    //URLGR[h֘A֐
	function URLDecode(const AStr: String): String;
	function URLEncode(const AStr: String): String;
    //UTF-8ϊ֐
    function WideToUTF8(const Source : WideString) : String;
    function UTF8ToWide(const Source : String) : WideString;
    //HTML֘A֐
    function DelHTMLTag(const Source : String) : String;

const
    dbt = 256 * 256;
    bt  = 256;
    ttt = 64 * 64 * 64;
    dtt = 64 * 64;
    tt  = 64;

implementation

function Base64Decode(const S : String) : String;
    function DecodeByte( c : Byte ) : Byte ;
    begin
        // 0-25
        if ( 65 <= c ) and ( c <= 90 ) then
            Result := Byte( c - 65 )
        // 26-51
        else if ( 97 <= c ) and ( c <= 122 ) then
            Result := Byte( 26 + c - 97 )
        // 52-61
        else if ( 48 <= c ) and ( c <= 57 ) then
            Result := Byte(52 + c - 48 )
        // 62
        else if ( 43 = c ) then
            Result := Byte(62)
        // 63
        else if ( 47 = c ) then
            Result := Byte(63)
        // 64 over
        else
            Result := c;
    end;
var
    a , b , c  : Byte;
    k : Integer;
    ln , n , Size : Integer;
    q , r : PChar;
begin
    n:=1;
    ln := Length(S);
    SetLength(Result,ln);
    q := PChar(S);
    r := PChar(Result);
    Size := 0;
    while n < ln-1 do
    begin
        k := DecodeByte(Byte((q+n-1)^)) * ttt + DecodeByte(Byte((q+n)^)) * dtt +
            DecodeByte(Byte((q+n+1)^)) * tt + DecodeByte(Byte((q+n+2)^));
        a := k div dbt;
        b := (k mod dbt) div bt;
        c := k mod bt;

        if (ln - 5) < n then
        begin
            if (q+n+1)^ = '=' then
            begin
                (r + Size)^ := Chr(a);
                Size := Size + 1;
            end
            else if (q+n+2)^ = '=' then
            begin
                (r + Size)^ := Chr(a);
                (r + Size + 1)^ := Chr(b);
                Size := Size + 2;
            end
            else
            begin
                (r + Size)^ := Chr(a);
                (r + Size + 1)^ := Chr(b);
                (r + Size + 2)^ := Chr(c);
                Size := Size + 3;
            end;
        end
        else
        begin
            (r + Size)^ := Chr(a);
            (r + Size + 1)^ := Chr(b);
            (r + Size + 2)^ := Chr(c);
            Size := Size + 3;
        end;

        Inc(n,4);
    end;
    Result := Copy(Result,1,Size);
end;

function Base64Encode(const S : String) : String;
    function EncodeByte( c : Byte ) : Byte ;
    begin
        // 'A'-'Z'
        if c <= 25 then
            Result := Byte( 65 + c )
        // 'a'-'z'
        else if ( 26 <= c ) and ( c <= 51 ) then
            Result := Byte( 97 + c - 26 )
        // '0'-'9'
        else if ( 52 <= c ) and ( c <= 61 ) then
            Result := Byte( Byte('0') + c - 52 )
        // '+'
        else if ( 62 = c ) then
            Result := Byte('+')
        // '/'
        else if ( 63 = c ) then
            Result := Byte('/')
        // 64 over
        else
            Result := c;
    end;
var
    a , b , c : Byte;
    ln , m , n ,Size : Integer;
    k : Longint;
    q , r : PChar;
begin
    n := 1;
    k := 0;
    ln := Length(S);
    SetLength(Result,ln*2);
    q := PChar(S);
    r := PChar(Result);
    Size := 0;
    while n <= ln do
    begin
        for m:=0 to 2 do
            case m of
                0:
                    k := Byte(q^) * dbt;
                1:
                    k := k + Byte((q+1)^) * bt;
                2:
                    k := k + Byte((q+2)^);
            end;
        a := k div ttt;
        k := k mod ttt;
        b := k div dtt;
        k := k mod dtt;
        c := k div tt;
        k := k mod tt;

        r^ := Chr(EncodeByte(a));
        (r+1)^ := Chr(EncodeByte(b));
        (r+2)^ := Chr(EncodeByte(c));
        (r+3)^ := Chr(EncodeByte(k));

        r := r + 4;
        q := q + 3;
        n := n + 3;
        Size := Size + 4;
    end;
    case ln mod 3 of
        0   :
            Result := Copy( Result , 1 , Size);
        1   :
            Result := Copy( Result , 1 , Size - 2 ) + '==';
        2   :
            Result := Copy( Result , 1 , Size - 1 ) + '=';
    end;
end;

function HTMLtoText(const Source : String) : String;
var
	l , n , size : Integer;
	temp : String;
    p , px , r , s : PChar;

    function HTMLCode : Char;
    var
        k , m : Integer;
        stemp : String;
    begin
        Result := Char(' ');
        stemp := '';

        for m := 0 to 10 do
        begin
            if (px + 2 + m)^ = ';' then
            begin
                for k := 0 to m - 1 do
                    stemp := stemp + (px + 2 + k)^;

                n := n + m + 3;

                try
                    Result := Char(StrtoInt(stemp));
                except
                end;

                Exit;
            end;
        end;

        n := n + 1;
    end;
begin
    temp := UpperCase(Source);
    l := Length(Source);
    SetLength(Result,l);
    r := PChar(Result);
    p := PChar(temp);
    s := PChar(Source);
    n := 0;
    size := 0;
    while n < l do
    begin
        px := p + n;
        if (px)^ = '&' then
        begin
            if ((px+1)^ = 'Q') and ((px+2)^ = 'U')
                and ((px+3)^ = 'O') and ((px+4)^ = 'T')
                and ((px+5)^ = ';') then
            begin
                r^ := '"';
                r := r + 1;
                n := n + 6;
                size := size + 1;
            end
            else if ((px+1)^ = 'N') and ((px+2)^ = 'B')
                and ((px+3)^ = 'S') and ((px+4)^ = 'P')
                and ((px+5)^ = ';') then
            begin
                r^ := ' ';
                r := r + 1;
                n := n + 6;
                size := size + 1;
            end
            else if ((px+1)^ = 'A') and ((px+2)^ = 'M')
                and ((px+3)^ = 'P') and ((px+4)^ = ';') then
            begin
                r^ := '&';
                r := r + 1;
                n := n + 5;
                size := size + 1;
            end
            else if ((px+1)^ = 'L') and ((px+2)^ = 'T')
                and ((px+3)^ = ';') then
            begin
                r^ := '<';
                r := r + 1;
                n := n + 4;
                size := size + 1;
            end
            else if ((px+1)^ = 'G') and ((px+2)^ = 'T')
                and ((px+3)^ = ';') then
            begin
                r^ := '>';
                r := r + 1;
                n := n + 4;
                size := size + 1;
            end
            else if ((px+1)^ = 'R') and ((px+2)^ = 'E')
                and ((px+3)^ = 'G') and ((px+4)^ = ';') then
            begin
                r^ := '(';
                (r + 1)^ := 'R';
                (r + 2)^ := ')';
                r := r + 3;
                n := n + 5;
                size := size + 3;
            end
            else if ((px+1)^ = 'C') and ((px+2)^ = 'O')
                and ((px+3)^ = 'P') and ((px+4)^ = 'Y')
                and ((px+5)^ = ';') then
            begin
                r^ := '(';
                (r + 1)^ := 'C';
                (r + 2)^ := ')';
                r := r + 3;
                n := n + 6;
                size := size + 3;
            end
            else if ((px+1)^ = '#') then
            begin
                r^ := HTMLCode;
                r := r + 1;
                size := size + 1;
            end
            else
            begin
                r^ := (s + n)^;
                n := n + 1;
                r := r + 1;
                size := size + 1;
            end;
        end
        else
        begin
            r^ := (s + n)^;
            n := n + 1;
            r := r + 1;
            size := size + 1;
        end;
    end;
    Result := Copy(Result,1,size);
end;

function TexttoHTML(const Source : String) : String;
var
    r , s : PChar;
    n , size : Integer;
begin
    SetLength(Result,Length(Source)*2);
    r := PChar(Result);
    s := PChar(Source);
    size := 0;
    for n := 0 to Length(Source) - 1 do
    begin
        if s^ = '&' then
        begin
            r^ := '&';
            (r+1)^ := 'a';
            (r+2)^ := 'm';
            (r+3)^ := 'p';
            (r+4)^ := ';';
            s := s + 1;
            r := r + 5;
            size := size + 5;
        end
        else
        if s^ = '<' then
        begin
            r^ := '&';
            (r+1)^ := 'l';
            (r+2)^ := 't';
            (r+3)^ := ';';
            s := s + 1;
            r := r + 4;
            size := size + 4;
        end
        else
        if s^ = '>' then
        begin
            r^ := '&';
            (r+1)^ := 'g';
            (r+2)^ := 't';
            (r+3)^ := ';';
            s := s + 1;
            r := r + 4;
            size := size + 4;
        end
        else
        if s^ = '"' then
        begin
            r^ := '&';
            (r+1)^ := 'q';
            (r+2)^ := 'u';
            (r+3)^ := 'o';
            (r+4)^ := 't';
            (r+5)^ := ';';
            s := s + 1;
            r := r + 6;
            size := size + 6;
        end
        else
        begin
            r^ := s^;
            s := s + 1;
            r := r + 1;
            size := size + 1;
        end;
    end;
    Result := Copy(Result,1,size);
end;

function URLDecode(const AStr: String): String;
var
    Sp, Rp, Cp: PChar;
begin
    SetLength(Result, Length(AStr));
    Sp := PChar(AStr);
    Rp := PChar(Result);
    while Sp^ <> #0 do
    begin
        if not (Sp^ in ['+','%']) then
            Rp^ := Sp^
        else
        if Sp^ = '+' then
            Rp^ := ' '
        else
        begin
            inc(Sp);
            if Sp^ = '%' then
                Rp^ := '%'
            else
            begin
                Cp := Sp;
                Inc(Sp);
                Rp^ := Chr(StrToInt('$' + Cp^ + Sp^));
            end;
        end;
        Inc(Rp);
        Inc(Sp);
    end;
    SetLength(Result, Rp - PChar(Result));
end;

function URLEncode(const AStr: String): String;
const
    NoConversion = ['A'..'Z','a'..'z','*','@','.','-',
                  '0'..'9','$','!','''','(',')',','];
var
    Sp, Rp: PChar;
begin
    SetLength(Result, Length(AStr) * 3);
    Sp := PChar(AStr);
    Rp := PChar(Result);
    while Sp^ <> #0 do
    begin
        if Sp^ in NoConversion then
            Rp^ := Sp^
        else
            if Sp^ = ' ' then
                Rp^ := '+'
            else
            begin
                CopyString(Rp,'%' + BytetoHex(Byte(Sp^)));
                Inc(Rp,2);
            end;
            Inc(Rp);
            Inc(Sp);
    end;
    SetLength(Result, Rp - PChar(Result));
end;

function WideToUTF8(const Source : WideString) : String;
var
    n: integer;
    pch: PChar;
    pwc: PWideChar;
    wc : word;
    sz : Integer;
    ln : Integer;

    procedure AddByte(b: byte);
    begin
        pch^ := char(b);
        ln := ln + 1;
        pch := pch + 1;
    end;
begin
    sz := Length(Source);
    SetLength(Result, sz * 3);
    FillChar(PChar(Result)^, sz * 3, #0);

    pwc := @Source[1];
    pch := PChar(Result);
    ln := 0;

    for n := 1 to sz do
    begin
        wc := Ord(pwc^);
        Inc(pwc);
        if (wc >= $0001) and (wc <= $007F) then
            AddByte(wc and $7F)
        else if (wc >= $0080) and (wc <= $07FF) then
        begin
            AddByte($C0 or ((wc shr 6) and $1F));
            AddByte($80 or (wc and $3F));
        end
        else
        begin // (wc >= $0800) and (wc <= $FFFF)
            AddByte($E0 or ((wc shr 12) and $0F));
            AddByte($80 or ((wc shr 6) and $3F));
            AddByte($80 or (wc and $3F));
        end;
    end;

    Setlength(Result,ln);
end;

function UTF8ToWide(const Source : String) : WideString;
var
    c1 : byte;
    c2 : byte;
    ch : byte;
    pch: PChar;
    pwc: PWideChar;
    sz : Integer;
    ln : Integer;
begin
    sz := Length(Source);
    SetLength(Result, sz);
    FillChar(PChar(Result)^, sz * 2, #0);

    pch := PChar(Source);
    pwc := PWideChar(Result);
    ln := 0;

    while sz > 0 do
    begin
        ch := byte(pch^);
        Inc(pch);

        if (ch and $80) = 0 then
        begin
            // 1-byte code
            Word(pwc^) := ch;
            Inc(pwc);
            Dec(sz);
            ln := ln + 1;
        end
        else if (ch and $E0) = $C0 then
        begin
            // 2-byte code
            if sz < 2 then Break;
            c1 := byte(pch^);
            Inc(pch);
            Word(pwc^) := (word(ch and $1F) shl 6) or (c1 and $3F);
            Inc(pwc);
            Dec(sz,2);
            ln := ln + 1;
        end
        else
        begin
            // 3-byte code
            if sz < 3 then Break;
            c1 := Byte(pch^);
            Inc(pch);
            c2 := Byte(pch^);
            Inc(pch);
            Word(pwc^) := (word(ch and $0F) shl 12) or
                            (word(c1 and $3F) shl 6) or
                            (c2 and $3F);
            Inc(pwc);
            Dec(sz,3);
            ln := ln + 1;
        end;
    end; //while

    SetLength(Result,ln);
end;

function DelHTMLTag(const Source : String) : String;
var
    r , s : PChar;
    ln , n , size : Integer;
    TagOn : Boolean;
begin
    size := 0;
    TagOn := False;
    ln := Length(Source);
    SetLength(Result,ln);
    s := PChar(Source);
    r := PChar(Result);
    for n := 1 to ln do
    begin
        if s^ = '<' then
            TagOn := True
        else if s^ = '>' then
            TagOn := False
        else if TagOn=False then
        begin
            r^ := s^;
            r := r + 1;
            size := size + 1;
        end;
        s := s + 1;
    end;
    Result := Copy(Result , 1 , size);
end;

end.