unit tn_bf;

interface

uses
    windows, tn_blowfish;

//procedures
    function BFRequestSize(szSource : Integer) : Integer;
    function BFEncode(pKey, pData : PChar ; szData, szBuf : Integer) : Integer;
    function BFDecode(pKey, pData : PChar ; szData, szBuf : Integer) : Integer;
    procedure BFEncodeValue(pKey : PChar ; var Value1, Value2 : Longword);
    procedure BFDecodeValue(pKey : PChar ; var Value1, Value2 : Longword);

implementation

function BFRequestSize(szSource : Integer) : Integer;
begin
    if szSource mod 8 = 0 then
        Result := szSource
    else
        Result := szSource div 8 * 8 + 8;
end;

function BFEncode(pKey, pData : PChar ; szData, szBuf : Integer) : Integer;
var
    ctx : BLOWFISH_CTX;
    n, cnt : Integer;
    ptr : PChar;
begin
    Result := 0;
    if BFRequestSize(szData) > szBuf then Exit;

    Blowfish_Init(@ctx, pKey, lstrlen(pKey));
    cnt := BFRequestSize(szData) div 8;
    ptr := pData;

    for n := 0 to cnt - 1 do
    begin
        Blowfish_Encrypt(@ctx, PLongword(ptr), PLongword(ptr + 4));
        Inc(ptr, 8);
    end;
end;

function BFDecode(pKey, pData : PChar ; szData, szBuf : Integer) : Integer;
var
    ctx : BLOWFISH_CTX;
    n, cnt : Integer;
    ptr : PChar;
begin
    Result := 0;

    if szData mod 8 <> 0 then Exit;
    if szData > szBuf then Exit;

    Blowfish_Init(@ctx, pKey, lstrlen(pKey));
    cnt := BFRequestSize(szData) div 8;
    ptr := pData;

    for n := 0 to cnt - 1 do
    begin
        Blowfish_Decrypt(@ctx, PLongword(ptr), PLongword(ptr + 4));
        Inc(ptr, 8);
    end;
end;

procedure BFEncodeValue(pKey : PChar ; var Value1, Value2 : Longword);
var
    ctx : BLOWFISH_CTX;
begin
    Blowfish_Init(@ctx, pKey, lstrlen(pKey));
    Blowfish_Encrypt(@ctx, @Value1, @Value2);
end;

procedure BFDecodeValue(pKey : PChar ; var Value1, Value2 : Longword);
var
    ctx : BLOWFISH_CTX;
begin
    Blowfish_Init(@ctx, pKey, lstrlen(pKey));
    Blowfish_Decrypt(@ctx, @Value1, @Value2);
end;

end.
