program jp5dx;

{
    Jupiter 5 Deluxe u[gXgbv&XVvO
}

uses
  windows,
  messages,
  trayicon,
  tn_utils,
  tn_internet,
  jp5_crypt,
  shellapi,
  tn_classes,
  mmsystem,
  jp5_dll in 'jp5_dll.pas',
  jp5_jobdlg in 'jp5_jobdlg.pas',
  jp5_about in 'jp5_about.pas',
  jp5_serv in 'jp5_serv.pas',
  jp5_item in 'jp5_item.pas',
  jp5_kern in 'jp5_kern.pas',
  jp5_settings in 'jp5_settings.pas',
  jp5_mailer in 'jp5_mailer.pas',
  jp5_itemchk in 'jp5_itemchk.pas',
  jp5_inst in 'jp5_inst.pas',
  jp5_update in 'jp5_update.pas',
  jp5_pass in 'jp5_pass.pas',
  jp5_regist in 'jp5_regist.pas',
  jp5_adv in 'jp5_adv.pas',
  jp5_info in 'jp5_info.pas',
  jp5_scinf in 'jp5_scinf.pas',
  jp5_sort in 'jp5_sort.pas',
  jp5_net in 'jp5_net.pas',
  jp5_help in 'jp5_help.pas';

type
    TJpTray     =   class(TTrayIcon)
        private
            ShowDebug : Boolean;
            ShowJob : Boolean;
            ShowAbout : Boolean;
            ShowSettings : Boolean;
            ShowUpdate : Boolean;
            ShowScript : Boolean;
            ShowScriptInst : Boolean;
            Timer : THandle;
            FirstTimer : Boolean;
            function Run(Index : Integer ; WebLogin : Boolean) : THandle;
            function GetPopCount(Path : String) : Integer;
            procedure MenuClear;
            procedure SetMenu;
        public
            constructor Create;
            destructor Destroy; override;
            procedure OnMouseDown(Button : TTrayButton); override;
            procedure OnDoubleClick(Button : TTrayButton); override;
            procedure OnCommand(WParam : Integer ; LParam : Integer); override;
            function OnMessage(Msg : Cardinal ; WParam : Integer ; LParam : Integer) : Integer; override;
            procedure OnTimer(WParam : Integer ; LParam : Integer); override;
            procedure OnHotKey(WParam : Integer ; LParam : Integer); override;
    end;

const
    MAIN_MENU   =   3001;

//bZ[W
const
    JP_QUIT     =   8181;
    JP_RUNSINGLE=   8182;

//\[X
const
    JP_NOSCRIPT =   3501;

var
    NoTimer : Boolean;

{$R *.RES}
{$R jp5dx_2.res}
//{$APPTYPE CONSOLE}

//******************************************************************************
//TJpTray

constructor TJpTray.Create;
var
    n : Cardinal;
begin
	if Settings.MonoIcon then
    	TrayIconHandle := LoadIcon(hInstance,'TRAYICON2')
    else
		TrayIconHandle := LoadIcon(hInstance,'TRAYICON');

    inherited Create(TrayIconHandle, 'Jupiter 5 Deluxe Edition');

    NoTimer := False;
    ShowDebug := False;
    ShowJob := False;
    ShowAbout := False;
    ShowSettings := False;
    ShowUpdate := False;
    ShowScript := False;
    ShowScriptInst := False;
    FirstTimer := True;

    //j[[h&Zbg
    MainMenu := LoadMenu(hInstance, MAKEINTRESOURCE(MAIN_MENU));
    LeftMenu := GetSubMenu(MainMenu, 0);
    RightMenu := GetSubMenu(MainMenu, 1);

    //^C}[X^[g
    Timer := SetTimer(Handle, 0, 200, nil);

    //e|
    PrepareTemporary;

    //zbgL[o^
    UnRegisterHotKey(Handle, 0);
    RegisterHotKey(Handle, 0, MOD_CONTROL or MOD_SHIFT, Cardinal('I'));
    RegisterHotKey(Handle, 1, MOD_CONTROL or MOD_SHIFT, Cardinal('R'));

    //Ctrl + Shift + (1-8)
    for n := 0 to 8 do
    begin
        RegisterHotKey(Handle, 10 + n, MOD_CONTROL or MOD_SHIFT
                        , Cardinal('1') + n);
    end;

    //Ctrl + Shift + 0
    RegisterHotKey(Handle, 19, MOD_CONTROL or MOD_SHIFT, Cardinal('0'));

    //j[ɃZbg
    SetMenu;
end;

destructor TJpTray.Destroy;
var
    n : Integer;
begin
    DestroyMenu(MainMenu);
    KillTimer(Timer, 0);

    //e|폜
    ClearTemporary;

    //ŏIXVL^
    SaveSettings(ExtractFilePath(ParamStr(0)) + 'jp5dx.ini'
                    , 'LastUpdate', IntToStr(Settings.LastUpdate));

    //zbgL[
    UnregisterHotKey(Handle, 0);
    UnregisterHotKey(Handle, 1);

    for n := 10 to 19 do
        UnregisterHotKey(Handle, n);

    //wvJ
    WinHelp(Handle
                , PChar(ExtractFilePath(ParamStr(0)) + 'jp5dx.hlp')
                , HELP_QUIT, 0);

    //ACRJ
    DestroyIcon(TrayIconHandle);

    inherited Destroy;
end;

procedure TJpTray.OnMouseDown(Button : TTrayButton);
begin
    case Button of
        mbtRight:
            PopupMenuRight;
        mbtleft:
            PopupMenuLeft;
    end;
end;

procedure TJpTray.OnDoubleClick(Button : TTrayButton);
begin
    if not ShowJob then
    begin
        ShowJob := True;
        ShowJobDlg;
    end;
end;

procedure TJpTray.OnCommand(WParam : Integer ; LParam : Integer);
var
    m, n : Integer;
    Index : Integer;
    List : TNStringList;
    Buf : array [0..255] of Char;
    temp : String;
begin
    case WParam of
        {
        1000:
            begin
                //JagaScriptfobK̋N
                if not ShowDebug then
                begin
                    ShowDebug := True;
                    ShowDebugDlg;
                end;
            end;
        }

        1100:
            begin
                //Ŝ̐ݒ
                if not ShowSettings then
                begin
                    ShowSettings := True;
                    ShowSettingsDlg;
                    ShowSettings := False;
                end;
            end;

        1101:
            begin
                //XNvg̃CXg[
                if not ShowScriptInst then
                begin
                	ShowScriptInst := True;
	                ShowInstScriptDlg;
                	ShowScriptInst := False;
                end;
            end;

        1102:
            begin
                //ŐVł̃`FbN
                if not ShowUpdate then
                begin
                    ShowUpdate := True;
                    DoUpdateCheck(False);
                    ShowUpdate := False;
                end;
            end;

        1103:
            begin
                //XNvg
                if not ShowScript then
                begin
                    ShowScript := True;
                    ShowScriptInfo;
                    ShowScript := False;
                end;
            end;

        1104:
        	begin
                //lbg[N̐ݒ
                if not ShowSettings then
                begin
                    ShowSettings := True;
                    ShowNetDlg;
                    ShowSettings := False;
                end;
            end;

        1201:
            begin
                //LbVNA
                for n := 0 to Items.Count - 1 do
                begin
                    if Items.Statuses.GetValue(n) = Integer(ITEM_IDLE) then
                    begin
                        List := SearchFile(Items.Paths[n] + 'cache\*.*');

                        for m := 0 to List.Count - 1 do
                        begin
                            DeleteFile(PChar(Items.Paths[n]
                                + 'cache\' + List.Strings[m]));
                        end;

                        List.Free;
                    end;
                end;
            end;

        1600:
            begin
                //WuXg̕\
                if not ShowJob then
                begin
                    ShowJob := True;
                    ShowJobDlg;
                    ShowJob := False;
                end
                else
                    ShowWindow(JobHandle, SW_RESTORE);
            end;

        1700:
            begin
                //ׂẴACes
                for n := 0 to Items.Count - 1 do
                begin
                    if Items.Statuses.GetValue(n) = Integer(ITEM_IDLE) then
                        Items.Statuses.SetValue(n, Integer(ITEM_WAIT));
                end;
            end;

        2000:
            begin
                //o[W_CAO\
                if not ShowAbout then
                begin
                    ShowAbout := True;
                    ShowAboutDlg;
	                ShowAbout := False;
                end;
            end;

        2001:
            begin
                //O[v\tgEFÃy[W\
                ShellExecute(TrayHandle, 'open'
                                , 'http://hp.vector.co.jp/authors/VA015579/'
                                ,nil ,nil ,SW_SHOW);
            end;

        2002:
            begin
                //wv\
                WinHelp(Handle
                        , PChar(ExtractFilePath(ParamStr(0)) + 'jp5dx.hlp')
                        , HELP_CONTEXT, 10000);
            end;

        2003:
            begin
                //Jupiter 5̃y[W\
                ShellExecute(TrayHandle, 'open'
                                , 'http://hp.vector.co.jp/authors/VA015579/jp5.htm'
                                ,nil ,nil ,SW_SHOW);
            end;

        JP_QUIT:
            begin
                //΂΂
                {
                if ShowDebug then
                begin
                    MessageBox(TrayHandle, PChar(LoadResourceString(ERR_OPENDEBUG)), PChar(TITLE)
                                , MB_TOPMOST or MB_SETFOREGROUND or MB_ICONWARNING);

                    Exit;
                end;
                }
                QuitTray;
            end;

        JP_RUNSINGLE:
            begin
                //GlobalAg擾Agpς݂̃Ag폜
                FillChar(Buf, SizeOf(Buf), #0);
                GlobalGetAtomName(LParam, Buf, SizeOf(Buf));
                GlobalDeleteAtom(LParam);
                temp := Trim(Buf);

                if temp <> '' then
                begin
                    for n := 0 to Items.Count - 1 do
                    begin
                        if Items.Mails.Strings[n] = temp then
                        begin
                            Run(n, False);
                            Break;
                        end;
                    end;
                end;
            end;
            
        JP_MENUUPDATE:
            begin
                SetMenu;
            end;

        9101:
        	begin
            	if Settings.WebBrowser <> '' then
					ShellExecute(Handle, 'open', PChar(Settings.WebBrowser)
                    				, PChar('"' + String(PChar(LParam)) + '"')
                                    , nil, SW_SHOW)
                else
					OpenFile(String(PChar(LParam)));
            end;

        else
            begin
                if WParam > 10000 then
                begin
                    Index := Items.ConvertIndex(WParam - 10001);
                    if Index <> -1 then
                        SendMessage(Handle, WM_JPSTART, Index, 0);
                end
                else if WParam = 1 then
                    AdwinWait := 1
                else if (WParam = 1) and (WParam = 33) then
                    AdwinWait := 2;
            end;
    end;
end;

function TJpTray.OnMessage(Msg : Cardinal ; WParam : Integer ; LParam : Integer) : Integer;
var
    Index : Integer;
    JpMsg : TJpMessage;
    Handle : THandle;
    FileName : String;
begin
    Result := Integer(False);

    if Msg = WM_JPMESSAGE then
    begin
        //bZ[W
        Index := Items.Handles.IndexOf(WParam);
        if Index = -1 then Exit;
        Items.Messages.Strings[Index] := Items.Messages.Strings[Index]
                                            + String(PChar(LParam)) + #13#10;
        JpMsg.Handle := WParam;
        JpMsg.Index := 0;
        JpMsg.MessageStr := PChar(Pointer(LParam));
        JpMsg.Types := mtMessage;

        SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);
    end
    else if Msg = WM_JPSTART then
    begin
        //s̊Jn
        Run(WParam, Boolean(LParam));
    end
    else if Msg = WM_JPSTOP then
    begin
        //M~̎w
        if Items.Statuses.GetValue(WParam) = Integer(ITEM_WAIT) then
            Items.Statuses.SetValue(WParam, Integer(ITEM_IDLE))
        else
        begin
            //łɎsĂ̂Œ~
            NoTimer := True;
            Handle := Items.Handles.GetValue(WParam);
            JupiterClose(Handle);
            Items.Handles.SetValue(WParam, 0);
            Items.Statuses.SetValue(WParam, Integer(ITEM_IDLE));
            NoTimer := False;
        end;

        //XV𑗐M
        JpMsg.Handle := 0;
        JpMsg.Index := WParam;
        JpMsg.MessageStr := nil;
        JpMsg.Types := mtUpdate;

        //j[̍XV
        SetMenu;

        SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);

        //_E[hꂽbZ[W`FbN
        if GetPopCount(Items.Paths[WParam]) > Items.LastPops.GetValue(WParam) then
        begin
            if Settings.NotifySound then
            begin
                FileName := ExtractFilePath(ParamStr(0)) + 'notify.wav';
                if FileExists(FileName) then
                    sndPlaySound(PChar(FileName), SND_ASYNC)
                else
                begin
                    Windows.Beep(1000, 100);
                    Sleep(40);
                    Windows.Beep(1000, 100);
                    Sleep(40);
                    Windows.Beep(1000, 100);
                    Sleep(40);
                    Windows.Beep(1500, 100);
                end;
            end;
        end;
    end
    else if Msg = WM_JPSTARTDL then
    begin
        //_E[hJn
        SendMessage(JobHandle, WM_JPCONNECT, Wparam, LParam);
    end
    else if Msg = WM_JPDOWNLOADING then
    begin
        SendMessage(JobHandle, WM_JPDOWNLOAD, Wparam, LParam);
    end
    else if Msg = WM_JPENDDL then
    begin
        //_E[h
        SendMessage(JobHandle, WM_JPFINISH, WParam, 0);
    end
    else
        Result := DefWindowproc(TrayHandle, Msg, WParam, LParam);
end;

procedure TJpTray.OnTimer(WParam : Integer ; LParam : Integer);
var
    n : Integer;
    DateCode : Integer;
    Handle : THandle;
    JpMsg : TJpMessage;
    JpCount : TJpCounter;
    NowTime : TDateTime;
    NowMinute : Integer;
    ExecTime : TDateTime;

    function GetNowMin(Time : TDateTime) : Integer;
    var
        h, m, s, ms : Integer;
    begin
        DecodeTime(Time, h, m, s, ms);
        Result := m;
    end;

    function GetNowHour(Time : TDateTime) : Integer;
    var
        h, m, s, ms : Integer;
    begin
        DecodeTime(Time, h, m, s, ms);
        Result := h;
    end;

    function GetDateCode : Integer;
    var
        y, m, d : Integer;
    begin
        DecodeDate(NowDateTime, y, m, d);
        Result := y * 372 + m * 31 * d;
    end;

begin
    if NoTimer then Exit;

    //XV
    if Settings.AutoUpdate then
    begin
        DateCode := GetDateCode;

        if (not ShowUpdate) and (Settings.LastUpdate < DateCode) then
        begin
            NoTimer := True;
            DoUpdateCheck(True);
            Settings.LastUpdate := DateCode;
            NoTimer := False;
        end;
    end;

    //ACeXg\
    if FirstTimer then
    begin
        NoTimer := True;

        if Settings.ShowItemList then
        begin
            //PostMessagełȂ΃_
            //SendMessageɂĂ܂ƃubN邽2xsĂ܂
            PostMessage(TrayHandle, WM_COMMAND, 1600, 0);
        end;

        if (Settings.StartOnBoot) or (RunAllItems) then
            PostMessage(TrayHandle, WM_COMMAND, 1700, 0)
        else if RunAddress <> '' then
        begin
            for n := 0 to Items.Count - 1 do
            begin
                if Items.Mails.Strings[n] = RunAddress then
                begin
                    Run(n, False);
                    Break;
                end;
            end;
        end;

        FirstTimer := False;
        NoTimer := False;
    end;

    //IɃACe`FbN
    for n := 0 to Items.Count - 1 do
    begin
        Handle := Items.Handles.GetValue(n);

        if Handle <> 0 then
        begin
            //s`FbN
            if not JupiterIsRunning(Handle) then
            begin
                //łɒ~Ă̂ŕ
                JupiterClose(Handle);

                //Xe[^XITEM_IDLEɂ
                Items.Statuses.SetValue(n, Integer(ITEM_IDLE));

                //\XV
                JpMsg.Handle := Handle;
                JpMsg.Index := 0;
                JpMsg.MessageStr := nil;
                JpMsg.Types := mtUpdate;
                SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);

                //j[̍XV
                SetMenu;

                //nh0ɃZbg
                Items.Handles.SetValue(n, 0);

                //_E[hꂽbZ[W`FbN
                if GetPopCount(Items.Paths[n] + 'savebox\')
                            > Items.LastPops.GetValue(n) then
                begin
                    if Settings.NotifySound then
                    begin
                        sndPlaySound(PChar(ExtractFilePath(ParamStr(0)) + 'notify.wav'), SND_ASYNC)
                    end;
                end;

                //ŏIsZbg
                Items.Lasts.SetValue(n, NowDateTime);
            end;
        end;
    end;

    //JEg
    JpCount.Err := 0;
    JpCount.Run := 0;
    JpCount.Stop := 0;
    JpCount.Wait := 0;
    JpCount.Dis := 0;

    for n := 0 to Items.Count - 1 do
    begin
        case TScriptStatus(Items.Statuses.GetValue(n)) of
            ITEM_EXEC:
                JpCount.Run := JpCount.Run + 1;
            ITEM_IDLE:
                JpCount.Stop := JpCount.Stop + 1;
            ITEM_ERR:
                JpCount.Err := JpCount.Err + 1;
            ITEM_WAIT:
                JpCount.Wait := JpCount.Wait + 1;
            ITEM_DISABLE:
                JpCount.Dis := JpCount.Dis + 1;
        end;
    end;

    if (JpCount.Run < Settings.Exec_Max)
        and (JpCount.Wait <> 0) then
    begin
        //ҋ@̃ACes
        NoTimer := True;

        for n := 0 to Items.Count - 1 do
        begin
            if Items.Statuses.GetValue(n) = Integer(ITEM_WAIT) then
                Run(n, False);
        end;

        NoTimer := False;
    end;

    //݂̎
    NowTime := NowDateTime;
    NowMinute := GetNowMin(NowTime);

    //s̃ACe`FbN
    for n := 0 to Items.Count - 1 do
    begin
        if Items.Statuses.GetValue(n) = Integer(ITEM_IDLE) then
        begin
            case TItemType(Items.ExecType.GetValue(n)) of
                EXE_NONE:
                    Continue;

                EXE_HOUR:
                    begin
                        if NowMinute = Items.Times.GetValue(n) then
                        begin
                            if GetNowHour(NowTime)
                                = GetNowHour(Items.Lasts.GetValue(n)) then
                                    Continue;

                            Items.Statuses.SetValue(n, Integer(ITEM_WAIT));
                        end;
                    end;

                EXE_INT:
                    begin
                        if Items.Times.GetValue(n) = 0 then Continue;

                        ExecTime := Items.Lasts.GetValue(n)
                                    + Items.Times.GetValue(n) / 1440;

                        if NowTime >= ExecTime then
                            Items.Statuses.SetValue(n, Integer(ITEM_WAIT))
                    end;
            end;
        end;
    end;

    SendMessage(JobHandle, WM_JPSETCOUNTER, Integer(@JpCount), 0);
end;

procedure TJpTray.OnHotKey(WParam : Integer ; LParam : Integer);
var
    Menu : HMENU;
    tp : TPoint;
    Index : Integer;
begin
    case WParam of
        0:
        	begin
                SetForegroundWindow(Handle);
	            PostMessage(Handle, WM_COMMAND, 1600, 0);
            end;

        1:
            begin
                Menu := GetSubMenu(LeftMenu, 2);
                SetForegroundWindow(Handle);
                GetCursorPos(tp);
                TrackPopupMenu(Menu, TPM_LEFTALIGN or TPM_RIGHTBUTTON
                                , tp.x, tp.y, 0, Handle, nil);
            end;

        else
            begin
                if (WParam >= 10) and (WParam <= 19) then
                begin
                    Index := Items.ConvertIndex(WParam - 10);

                    if Index <> -1 then
                        SendMessage(Handle, WM_JPSTART, Index, 0);
                end;
            end;
    end;
end;

function TJpTray.Run(Index : Integer ; WebLogin : Boolean) : THandle;
var
    temp, stemp, ttemp : String;
    FileName : String;
    ScriptFile : String;
    CookiePath : String;
    CachePath : String;
	NoCache : Boolean;
    ItemPath : String;
    User : String;
    Pass : String;
    Option : String;
    Address : String;
    Item : TItemInfo;
    JpMsg : TJpMessage;
    Running : Integer;
    Port : Integer;
    n : Integer;

    function ConvertScript(const Source : WideString) : String;
    var
		n : Integer;
        ch : WideChar;
        temp : String;
    begin
    	temp := '';

    	for n := 1 to Length(Source) do
        begin
        	 ch := Source[n];

             case ch of
             	'"':
                	temp := temp + '\"';
                '''':
                	temp := temp + '\''';
             	'\':
                	temp := temp +'\\';
                else
                	temp := temp + ch;
             end;
        end;

        Result := temp;
	end;

begin
    Result := 0;

    temp := Items.Paths[Index];

    //fBNg`FbN
    if not DirectoryExists(temp + 'loadbox') then MkDir(temp + 'loadbox\');
    if not DirectoryExists(temp + 'savebox') then MkDir(temp + 'savebox\');
    if not DirectoryExists(temp + 'cache') then MkDir(temp + 'cache\');

    FileName := Items.Paths[Index] + 'item.ini';

    if UpperCase(Trim(GetSettings(FileName, 'SaveCache'))) = 'TRUE' then
    begin
        CachePath := temp + 'cache\';
        NoCache := False;
    end
    else
    begin
        CachePath := TempPath;
        NoCache := True;
    end;

    if UpperCase(Trim(GetSettings(FileName, 'SaveCookie'))) = 'TRUE' then
        CookiePath := temp + 'cache\'
    else
        CookiePath := '';

    //SaveBoxPath := temp + 'savebox\';
    //LoadBoxPath := temp + 'loadbox\';

    ItemPath := temp;
    ScriptFile := Scripts.GetFileNameFromTitle(Items.Scripts.Strings[Index]);

    if (ScriptFile = '') or (not FileExists(ScriptFile)) then
    begin
        temp := LoadResourceString(JP_NOSCRIPT);
        Items.Messages.Strings[Index] := temp;
        Items.Statuses.SetValue(Index, Integer(ITEM_ERR));

        //bZ[Wǉ
        JpMsg.Handle := 0;
        JpMsg.Index := Index;
        JpMsg.MessageStr := PChar(temp);
        JpMsg.Types := mtMessage;
        SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);

        //ACe̍XV
        JpMsg.Types := mtUpdate;
        SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);

        //j[̍XV
        SetMenu;

        Exit;
    end;

    //s`FbN
    Running := 0;

    for n := 0 to Items.Count - 1 do
    begin
        if Items.Statuses.GetValue(n) = Integer(ITEM_EXEC) then
            Running := Running + 1;
    end;

    if Running >= Settings.Exec_Max then
    begin
        //ősɓBĂ
        Items.Statuses.SetValue(Index, Integer(ITEM_WAIT));

        JpMsg.Handle := 0;
        JpMsg.Index := Index;
        JpMsg.MessageStr := nil;
        JpMsg.Types := mtUpdate;
        SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);

        //j[̍XV
        SetMenu;
        Exit;
    end;

    //s
    FileName := temp + 'item.ini';
    FillChar(Item, SizeOf(Item), #0);
    User := GetSettings(FileName, 'User');
    Pass := PasswordDecode(GetSettings(FileName, 'Pass'));
    Option := Base64Decode(GetSettings(FileName, 'Option'));
    Address := GetSettings(FileName, 'Address');

    //POP&SMTPgݍ
    stemp := '';

    //vR[h𐶐
    ttemp := GetSettings(FileName, 'PopAddress');
    stemp := stemp + 'Jupiter._POP_SERVER = "' + ConvertScript(ttemp) + '";' + CRLF;

    ttemp := GetSettings(FileName, 'SmtpAddress');
    stemp := stemp + 'Jupiter._SMTP_SERVER = "' + ConvertScript(ttemp) + '";' + CRLF;

    Port := StrToInt(GetSettings(FileName, 'PopPort'));
    stemp := stemp + 'Jupiter._POP_PORT = "' + IntToStr(Port) + '";' + CRLF;

    Port := StrToInt(GetSettings(FileName, 'SmtpPort'));
    stemp := stemp + 'Jupiter._SMTP_PORT = "' + IntToStr(Port) + '";' + CRLF;

    if UpperCase(GetSettings(FileName, 'Delete')) <> 'FALSE'  then
        stemp := stemp + 'Jupiter._DELETE = true;' + CRLF
    else
        stemp := stemp + 'Jupiter._DELETE = false;' + CRLF;

    if UpperCase(GetSettings(FileName, 'APOP')) <> 'TRUE'  then
        stemp := stemp + 'Jupiter._APOP = false;' + CRLF
    else
        stemp := stemp + 'Jupiter._APOP = true;' + CRLF;

    if WebLogin then
        stemp := stemp + 'Jupiter._WEB_LOGIN = true;' + CRLF
    else
        stemp := stemp + 'Jupiter._WEB_LOGIN = false;' + CRLF;

	if Settings.UseProxy then
    	stemp := stemp + 'Jupiter.proxyAddr = "'
        			+ ConvertScript(Settings.Proxy_Addr) + '";' + CRLF
    else
    	stemp := stemp + 'Jupiter.proxyAddr = "";' + CRLF;

    if Settings.UseSpeedMail then
        stemp := stemp + 'Jupiter._SPEEDMAIL = true;' + CRLF
    else
        stemp := stemp + 'Jupiter._SPEEDMAIL = false;' + CRLF;

    if NoCache then
        stemp := stemp + 'Jupiter._NO_CACHE = true;' + CRLF
    else
        stemp := stemp + 'Jupiter._NO_CACHE = false;' + CRLF;

	//WIȍ
	stemp := stemp
    			+	'Jupiter.mailAddress = "' + ConvertScript(Address) + '";' + CRLF
    			+	'Jupiter.mailAddr = "' + ConvertScript(Address) + '";' + CRLF
                +	'Jupiter.user = "' + ConvertScript(User) + '";' + CRLF
                +	'Jupiter.pass = "' + ConvertScript(Pass) + '";' + CRLF
                +	'Jupiter.proxyPort = ' + IntToStr(Settings.Proxy_Port) + ';' + CRLF
                +	'Jupiter.dnsAddr = "' + ConvertScript(Settings.Dns) + '";' + CRLF
                +	'Jupiter.proxyUser = "' + ConvertScript(Settings.Proxy_User) + '";' + CRLF
                +	'Jupiter.proxyPass = "' +  ConvertScript(Settings.Proxy_Pass) + '";' + CRLF;

    if stemp <> '' then Option := stemp + Option;

    Item.FileName := PChar(ScriptFile);
    Item.Handle := TrayHandle;
    Item.Cache := PChar(CachePath);
    Item.Cookie := PChar(CookiePath);
    Item.ItemPath := PChar(ItemPath);
    Item.Temporary := PChar(TempPath);
    Item.Option := PChar(Option);

    if Settings.Priority then
        Item.Priority := THREAD_PRIORITY_NORMAL
    else
        Item.Priority := THREAD_PRIORITY_IDLE;

    //XNvgGW̋N
    Result := JupiterOpen(@Item);

    //XNvgGW̃RpC
    if JupiterCompile(Result) then
    begin
        //sJn
        JupiterRun(Result, False);

        Items.Messages.Strings[Index] := '';
        Items.Statuses.SetValue(Index, Integer(ITEM_EXEC));
        Items.Handles.SetValue(Index, Result);
        Items.LastPops.SetValue(Index, GetPopCount(Items.Paths[Index]
                                                                + 'savebox\'));
    end
    else
    begin
        //bZ[W̎擾
        SetLength(temp, JupiterGetCompileSize(Result));
        JupiterGetCompileStr(Result, PChar(temp));

        //G[
        JupiterClose(Result);
        Result := 0;
        Items.Statuses.SetValue(Index, Integer(ITEM_ERR));

        //\̍XV
        Items.Messages.Strings[Index] := temp;
        JpMsg.Handle := 0;
        JpMsg.Index := Index;
        JpMsg.MessageStr := PChar(temp);
        JpMsg.Types := mtMessage;
        SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);

        //j[̍XV
        SetMenu;
        Exit;
    end;

    //\̍XV
    JpMsg.Handle := 0;
    JpMsg.Index := Index;
    JpMsg.MessageStr := nil;
    JpMsg.Types := mtUpdate;
    SendMessage(JobHandle, WM_JPMSG, Integer(@JpMsg), 0);

    //j[̍XV
    SetMenu;
end;

function TJpTray.GetPopCount(Path : String) : Integer;
var
    List : TNStringList;
begin
    List := SearchFile(Path + '*.eml');
    Result := List.Count;
    List.Free;
end;

procedure TJpTray.MenuClear;
var
    n : Integer;
    Menu : THandle;
    Count : Integer;
begin
    Menu := GetSubMenu(LeftMenu, 2);
    Count := GetMenuItemCount(Menu);

    for n := Count - 1 downto 0 do
        DeleteMenu(Menu, n, MF_BYPOSITION);
end;

procedure TJpTray.SetMenu;
var
    n : Integer;
    Index : Integer;
    Menu : THandle;
    temp : String;
    HotKey : String;
begin
    MenuClear;
    Menu := GetSubMenu(LeftMenu, 2);

    if Items.Count = 0 then
        AppendMenu(Menu, MF_STRING or MF_GRAYED , 10001
                        , PChar(LoadResourceString(4402)))
    else
    begin
        for n := 0 to Items.Count - 1 do
        begin
            if n < 10 then
                HotKey := 'Ctrl+Shift+' + IntToStr((n + 1) mod 10)
            else
                HotKey := ' ';

            Index := Items.ConvertIndex(n);
            temp := Format(LoadResourceString(4401)
                            , [Items.Titles.Strings[Index]
                            , SearchFileCount(Items.Paths[Index]
                                                    + 'savebox\*.eml')
                            , SearchFileCount(Items.Paths[Index]
                                                    + 'inbox\*.eml')
                            , HotKey]);

            if Items.Statuses.GetValue(Index) <> Integer(ITEM_IDLE) then
                AppendMenu(Menu, MF_STRING or MF_GRAYED, 10001 + n, PChar(temp))
            else
                AppendMenu(Menu, MF_STRING, 10001 + n, PChar(temp));
        end;
    end;
end;

//******************************************************************************
//WinMain

function WinMain(hThisInst , hPrevInst : THandle ; lpArgs:pChar ; cmdShow : Integer) : Integer; stdcall;
const
    JP5_STRING      =   'GRAPESOFTWARE_JUPITER_VERSION_5';
var
    msg : TMsg;
    Tray : TJpTray;
    Handle : THandle;
    Data : String;
    CmdLine : String;
    AddrAtom : ATOM;
begin
    Result := 0;
    CmdLine := ParamStr(1);

    if CmdLine = '/?' then
    begin
        Data :=     'Jupiter 5 Deluxe Edition[' + GetVersion + ']'#13#10
                +   'Copyright 1999-2002 Grape Software Associates / T.Nak'#13#10#13#10
                +   'jp5dx.exe [/r:mailaddress] [/a] [/?]'#13#10#13#10
                +   '/r:mailaddress'#9'Run target item.'#13#10
                +   '/a'#9#9'Run all items.'#13#10
                +   '/?'#9#9'Show this help.';

        MessageBox(0, PChar(Data), 'Infomation about command line'
                    , MB_ICONASTERISK);
        Exit;
    end
    else if UpperCase(CmdLine) = '/A' then
    begin
        RunAllItems := True;
    end
    else if UpperCase(Copy(CmdLine, 1, 3)) = '/R:' then
    begin
        RunAddress := Trim(Copy(CmdLine, 4, Length(CmdLine) - 3));

        if Length(RunAddress) > 255 then
        begin
            MessageBox(0, 'Mail address is too long!'
                        , 'Command line error', MB_ICONWARNING);
            Exit;
        end;
    end;

    //dÑ`FbN
    Handle := OpenMutex(MUTEX_ALL_ACCESS, False, JP5_STRING);

    if Handle <> 0 then
    begin
        //łɋNĂ
        CloseHandle(Handle);
        Handle := FindWindow('TNGSJP5', nil);

        if RunAllItems then
        begin
            Handle := FindWindow('TNGSJP5', nil);
            SendMessage(Handle, WM_COMMAND, 1700, 0);
        end
        else if RunAddress <> '' then
        begin
            //AtomɕZbg
            AddrAtom := GlobalAddAtom(PChar(RunAddress));
            PostMessage(Handle, WM_COMMAND, JP_RUNSINGLE, Integer(AddrAtom));
        end
        else
        begin
            MessageBox(TrayHandle, PChar(LoadResourceString(2111))
                        , TITLE
                        , MB_TOPMOST or MB_SETFOREGROUND or MB_ICONWARNING);
        end;

        Result := 0;
        Exit;
    end;

    //Mutexo^
    Handle := CreateMutex(nil, False, JP5_STRING);
    Tray := TJpTray.Create;
    TrayHandle := Tray.Handle;

    if DirectoryExists(TempPath) then
    begin
    	while GetMessage(msg,0,0,0) do
		begin
        	TranslateMessage(msg);
	        DispatchMessage(msg);
    	end;
    end;

    Tray.Free;
    Result := 0;

    //Mutex
    ReleaseMutex(Handle);

    //LEBhE
    Handle := FindWindow(nil, 'Thank you for using Jupiter 5');
    SendMessage(Handle, WM_COMMAND, 9000, 0);
end;

begin
    WinMain(hInstance, 0, nil, cmdShow);
end.

