unit jp5_settings;

interface

uses
    windows, messages, jp5_kern, commctrl, tn_stdctl, tn_utils, tn_fw;

type
    TSettingsDlg    =   class(WModalDialog)
        private
            procedure OnNotify(var Message: TMessage); message WM_NOTIFY;
        public
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnClose(Sender : WObject ; var DoClose : Boolean); override;
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
    end;

//procedures
    procedure ShowSettingsDlg;

implementation

//******************************************************************************
// TSettingsDlg

procedure TSettingsDlg.OnShow(Sender : WObject ; var Return : LRESULT);
begin
    //͈͐ݒ(1`15)
    SendMessage(GetHandle(1003), UDM_SETRANGE, 0, MAKELONG(15, 1));
    SendMessage(GetHandle(1003), UDM_SETPOS, 0, MAKELONG(Settings.Exec_Max, 0));

    //Ctl_SetText(GetHandle(1000), Settings.Proxy_Addr);
    //Ctl_SetText(GetHandle(1001), IntToStr(Settings.Proxy_Port));
    Ctl_SetText(GetHandle(1002), IntToStr(Settings.Exec_Max));
    Ctl_SetCheck(GetHandle(1004), Settings.UsePop);
    Ctl_SetCheck(GetHandle(1005), Settings.UseSmtp);
    Ctl_SetCheck(GetHandle(1006), Settings.DenyNoLocalHost);
    Ctl_SetText(GetHandle(1007), IntToStr(Settings.Pop_Port));
    Ctl_SetText(GetHandle(1008), IntToStr(Settings.Smtp_Port));
    Ctl_SetCheck(GetHandle(1009), Settings.ExecImmediately);
    Ctl_SetCheck(GetHandle(1010), Settings.UseSpeedMail);
    Ctl_SetCheck(GetHandle(1011), Settings.NotifySound);
    Ctl_SetCheck(GetHandle(1012), Settings.ShowItemList);
    Ctl_SetCheck(GetHandle(1013), Settings.StartOnBoot);
    Ctl_SetCheck(GetHandle(1014), Settings.AutoUpdate);
    Ctl_SetCheck(GetHandle(1015), Settings.Priority);
end;

procedure TSettingsDlg.OnClose(Sender : WObject ; var DoClose : Boolean);
begin
    //SendMessage(TrayHandle, WM_COMMAND, JP_HIDESETTINGS, 0);
    inherited;
end;

procedure TSettingsDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
begin
    case wParam of
        IDOK:
            begin
                //ݒϐɃZbg
                //Settings.Proxy_Addr := Ctl_GetText(GetHandle(1000));
                //Settings.Proxy_Port := StrToInt(Ctl_GetText(GetHandle(1001)));
                Settings.Exec_Max := StrToInt(Ctl_GetText(GetHandle(1002)));
                Settings.UsePop := Ctl_IsChecked(GetHandle(1004));
                Settings.UseSmtp := Ctl_IsChecked(GetHandle(1005));
                Settings.DenyNoLocalHost := Ctl_IsChecked(GetHandle(1006));
                Settings.Pop_Port := StrToInt(Ctl_GetText(GetHandle(1007)));
                Settings.Smtp_Port := StrToInt(Ctl_GetText(GetHandle(1008)));
                Settings.ExecImmediately := Ctl_IsChecked(GetHandle(1009));
                Settings.UseSpeedMail := Ctl_IsChecked(GetHandle(1010));
                Settings.NotifySound := Ctl_IsChecked(GetHandle(1011));
                Settings.ShowItemList := Ctl_IsChecked(GetHandle(1012));
                Settings.StartOnBoot := Ctl_IsChecked(GetHandle(1013));
                Settings.AutoUpdate := Ctl_IsChecked(GetHandle(1014));
                Settings.Priority := Ctl_IsChecked(GetHandle(1015));

                //ݒۑ
                Save_Settings;

                //
                Close;
                //SendMessage(TrayHandle, WM_COMMAND, JP_HIDESETTINGS, 0);
            end;

        IDCANCEL:
            begin
                Close;
                //SendMessage(TrayHandle, WM_COMMAND, JP_HIDESETTINGS, 0);
            end;

        else
            inherited;
    end;
end;

procedure TSettingsDlg.OnNotify(var Message: TMessage);
var
    Msg : TMessage;
    Index : Integer;
begin
    Msg := TMessage(Message);

    if Msg.WParam = 1003 then
    begin
        Index := PNMUpDown(Pointer(Msg.LParam)).iPos
                    + PNMUpDown(Pointer(Msg.LParam)).iDelta;

        if Index > 15 then Index := 15;
        if Index < 1 then Index := 1;
        Ctl_SetText(GetHandle(1002), IntToStr(Index));
    end;
end;

//******************************************************************************

procedure ShowSettingsDlg;
var
    Dlg : TSettingsDlg;
begin
	if JobHandle = 0 then
	    Dlg := TSettingsDlg.Create(TrayHandle, '2007')
    else
	    Dlg := TSettingsDlg.Create(JobHandle, '2007');

    Dlg.ShowModal;
    Dlg.Free;
end;

end.
