unit jp5_scinf;

interface

uses
    windows, messages, tn_fw, jp5_kern, tn_stdctl, tn_utils, tn_classes;

type
    TScriptInfoDlg  =   class(WModalDialog)
        private
            Files : TNStringList;
            procedure SetCaption;
        public
            destructor Destroy; override;
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnDestroy(Sender : WObject ; var Return : LRESULT); override;
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
    end;

//procedure
    procedure ShowScriptInfo;

implementation

//******************************************************************************
// TScriptInfoDlg

destructor TScriptInfoDlg.Destroy;
begin
    Files.Free;
    inherited;
end;

procedure TScriptInfoDlg.OnShow(Sender : WObject ; var Return : LRESULT);
var
    n : Integer;
    Path : String;
    temp : String;
    Han : THandle;
begin
    Path := ExtractFilePath(ParamStr(0)) + 'scripts\';
    Files := SearchFile(Path + '*.js');
    Han := GetHandle(1001);

    for n := 0 to Files.Count - 1 do
    begin
        temp := Trim(GetSettings(Path + Files.Strings[n], '//ScriptTitle'));

        if temp <> '' then
            List_Add(Han, temp)
        else
            List_Add(Han, Files.Strings[n]);
    end;

    List_SetIndex(Han, 0);
    SetCaption;
    SetFocus(Han);
end;

procedure TScriptInfoDlg.OnDestroy(Sender : WObject ; var Return : LRESULT);
begin
    //SendMessage(TrayHandle, WM_COMMAND, JP_HIDESCINFO, 0);
end;

procedure TScriptInfoDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
var
    Index : Integer;
    Han : THandle;
begin
    if HIWORD(wParam) = LBN_SELCHANGE then
        SetCaption
    else if wParam = 1003 then
    begin
        Han := GetHandle(1001);
        Index := List_GetIndex(Han);

        if Index <> -1 then
        begin
            OpenFile(GetSettings(ExtractFilePath(ParamStr(0))
                            + 'scripts\' + Files.Strings[Index]
                            , '//JumpURL'));
        end;
    end
    else if wParam = 1004 then
    begin
        Han := GetHandle(1001);
        Index := List_GetIndex(Han);

        if Index <> -1 then
            EditFile(ExtractFilePath(ParamStr(0))
                        + 'scripts\' + Files.Strings[Index]);
    end
    else
        inherited;
end;

procedure TScriptInfoDlg.SetCaption;
var
    Index : Integer;
    Han : THandle;
    FileName : String;
    temp : String;
begin
    Han := GetHandle(1001);
    Index := List_GetIndex(Han);

    if Index = -1 then
    begin
        Ctl_SetText(GetHandle(1002), '-');
        Ctl_SetText(GetHandle(1005), '-');
        Ctl_SetText(GetHandle(1006), '-');
        Ctl_SetText(GetHandle(1007), '-');

        Ctl_SetEnabled(GetHandle(1003), False);
        Ctl_SetEnabled(GetHandle(1004), True);
    end
    else
    begin
        FileName := ExtractFilePath(ParamStr(0))
                        + 'scripts\' + Files.Strings[Index];
        Ctl_SetText(GetHandle(1002), List_GetItem(Han, Index));
        Ctl_SetText(GetHandle(1005), GetSettings(FileName, '//Developer'));
        Ctl_SetText(GetHandle(1006), GetSettings(FileName, '//ScriptVersion'));
        Ctl_SetText(GetHandle(1007), GetSettings(FileName, '//Copyright'));

        temp := GetSettings(FileName, '//JumpURL');

        if temp <> '' then
            Ctl_SetEnabled(GetHandle(1003), True)
        else
            Ctl_SetEnabled(GetHandle(1003), False);

        Ctl_SetEnabled(GetHandle(1004), True);
    end;
end;

//******************************************************************************

procedure ShowScriptInfo;
var
    Dlg : TScriptInfoDlg;
begin
	if JobHandle = 0 then
	    Dlg := TScriptInfoDlg.Create(TrayHandle, '2015')
    else
	    Dlg := TScriptInfoDlg.Create(JobHandle, '2015');

    Dlg.ShowModal;
    Dlg.Free;
end;

end.
