unit jp5_net;

interface

uses
	windows, tn_fw, tn_utils, jp5_kern, tn_stdctl, commdlg;

type
    TNetDlg    =   class(WModalDialog)
        public
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnDestroy(Sender : WObject ; var Return : LRESULT); override;
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
    end;

//procedures
    procedure ShowNetDlg;

implementation

procedure TNetDlg.OnShow(Sender : WObject ; var Return : LRESULT);
begin
    Ctl_SetText(GetHandle(1001), Settings.Proxy_Addr);
    Ctl_SetText(GetHandle(1002), IntToStr(Settings.Proxy_Port));
    Ctl_SetText(GetHandle(1007), Settings.Proxy_User);
    Ctl_SetText(GetHandle(1008), Settings.Proxy_Pass);
    Ctl_SetText(GetHandle(1003), Settings.Dns);
    Ctl_SetCheck(GetHandle(1004), Settings.UseProxy);
    Ctl_SetText(GetHandle(1005), Settings.WebBrowser);
end;

procedure TNetDlg.OnDestroy(Sender : WObject ; var Return : LRESULT);
begin
	
end;

procedure TNetDlg.OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer
													; var Return : LRESULT);
var
	fileinf : OPENFILENAME;
    filter : String;
	title : String;
    namebuf : array [0..MAX_PATH - 1] of Char;
    titlebuf : array [0..MAX_PATH - 1] of Char;
begin
	case WORD(wParam) of
    	IDOK:
        	begin
            	Settings.Proxy_Addr := Ctl_GetText(GetHandle(1001));
                Settings.Proxy_Port := StrToInt(Ctl_GetText(GetHandle(1002)));
                Settings.Proxy_User := Ctl_GetText(GetHandle(1007));
                Settings.Proxy_Pass := Ctl_GetText(GetHandle(1008));
                Settings.Dns := Ctl_GetText(GetHandle(1003));
                Settings.UseProxy := Ctl_IsChecked(GetHandle(1004));
                Settings.WebBrowser := Ctl_GetText(GetHandle(1005));

                //ݒۑ
                Save_Settings;
            end;

        1006:
        	begin
				title := LoadResourceString(4601);
            	filter := LoadResourceString(4602) + #0
                			+ LoadResourceString(4603) + #0#0;
            	FillChar(fileinf, SizeOf(OPENFILENAME), #0);
                FillChar(namebuf, SizeOf(namebuf), #0);
                FillChar(titlebuf, SizeOf(titlebuf), #0);

                //ݑIĂt@CZbg
                if Ctl_GetText(GetHandle(1005)) <> '' then
                	lstrcpy(@namebuf, PChar(Ctl_GetText(GetHandle(1005))))
                else
                	lstrcpy(@namebuf, PChar(ExtractFilePath(ParamStr(0))));


                //ꂶWin 95/98/NT 4.0gȂ
                //fileinf.lStructSize := SizeOf(OPENFILENAME);
                fileinf.lStructSize := 76;

				fileinf.hwndOwner := Handle;
				fileinf.lpstrFilter := PChar(filter);
                fileinf.lpstrFile := @namebuf;
				fileinf.nMaxFile := MAX_PATH;
				fileinf.Flags := OFN_FILEMUSTEXIST or OFN_HIDEREADONLY;
                fileinf.lpstrDefExt := '.exe';
				fileinf.nMaxFileTitle := 64;
                fileinf.lpstrFileTitle := @titlebuf;
				fileinf.lpstrTitle := PChar(Title);
                fileinf.nFilterIndex := 1;

				if GetOpenFileName(fileinf) then
                begin
					Ctl_SetText(GetHandle(1005), namebuf);
                end;
            end;
    end;

	inherited;
end;

//******************************************************************************

procedure ShowNetDlg;
var
    Dlg : TNetDlg;
begin
	if JobHandle = 0 then
	    Dlg := TNetDlg.Create(TrayHandle, '2018')
    else
	    Dlg := TNetDlg.Create(JobHandle, '2018');

    Dlg.ShowModal;
    Dlg.Free;
end;

end.
